/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.fluids.FluidEffectRegistry;
import com.tiviacz.travelersbackpack.gui.inventory.InventoryTravelersBackpack;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.items.ItemHose;
import com.tiviacz.travelersbackpack.tileentity.TileEntityTravelersBackpack;
import com.tiviacz.travelersbackpack.util.Reference;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class ServerActions {
    public static void cycleTool(EntityPlayer player, int direction) {
        if (CapabilityUtils.isWearingBackpack(player)) {
            InventoryTravelersBackpack inv = CapabilityUtils.getBackpackInv(player);
            ItemStack heldItem = player.func_184614_ca();
            if (direction < 0) {
                player.func_184611_a(EnumHand.MAIN_HAND, inv.func_70301_a(48));
                inv.func_70299_a(48, inv.func_70301_a(49));
                inv.func_70299_a(49, heldItem);
            } else if (direction > 0) {
                player.func_184611_a(EnumHand.MAIN_HAND, inv.func_70301_a(49));
                inv.func_70299_a(49, inv.func_70301_a(48));
                inv.func_70299_a(48, heldItem);
            }
            CapabilityUtils.synchronise(player);
            CapabilityUtils.synchroniseToOthers(player);
            inv.func_70296_d();
        }
    }

    public static void emptyTank(int tankType, EntityPlayer player, World world) {
        InventoryTravelersBackpack inv = CapabilityUtils.getBackpackInv(player);
        FluidTank tank = tankType == 1 ? inv.getLeftTank() : inv.getRightTank();
        world.func_184133_a(null, player.func_180425_c(), tank.getFluid().getFluid().getEmptySound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        tank.drain(Reference.BASIC_TANK_CAPACITY, true);
        inv.markTankDirty();
        player.func_71053_j();
        CapabilityUtils.synchronise(player);
        CapabilityUtils.synchroniseToOthers(player);
    }

    public static boolean setFluidEffect(World world, EntityPlayer player, FluidTank tank) {
        FluidStack fluidStack = tank.getFluid();
        boolean done = false;
        if (FluidEffectRegistry.hasFluidEffectAndCanExecute(fluidStack, world, (Entity)player)) {
            done = FluidEffectRegistry.executeFluidEffectsForFluid(fluidStack, (Entity)player, world);
        }
        return done;
    }

    public static void toggleSleepingBag(EntityPlayer player, int x, int y, int z) {
        World world = player.field_70170_p;
        BlockPos pos = new BlockPos(x, y, z);
        if (world.func_175625_s(pos) instanceof TileEntityTravelersBackpack) {
            TileEntityTravelersBackpack te = (TileEntityTravelersBackpack)world.func_175625_s(pos);
            if (!te.isSleepingBagDeployed()) {
                if (te.deploySleepingBag(world, pos)) {
                    player.func_71053_j();
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation(I18n.func_74837_a((String)"actions.deploy_sleeping_bag", (Object[])new Object[0]), new Object[0]));
                }
            } else {
                te.removeSleepingBag(world);
            }
            player.func_71053_j();
        }
    }

    public static void equipBackpack(EntityPlayer player) {
        ITravelersBackpack cap = CapabilityUtils.getCapability(player);
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            if (!cap.hasWearable()) {
                ItemStack stack = player.func_184614_ca().func_77946_l();
                cap.setWearable(stack);
                player.func_184614_ca().func_190918_g(1);
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187728_s, SoundCategory.PLAYERS, 1.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                CapabilityUtils.synchronise(player);
                CapabilityUtils.synchroniseToOthers(player);
            }
            player.func_71053_j();
        }
    }

    public static void unequipBackpack(EntityPlayer player) {
        ITravelersBackpack cap = CapabilityUtils.getCapability(player);
        World world = player.field_70170_p;
        CapabilityUtils.onUnequipped(world, player, cap.getWearable());
        if (!world.field_72995_K) {
            ItemStack wearable = cap.getWearable().func_77946_l();
            if (!player.field_71071_by.func_70441_a(wearable)) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("actions.unequip_backpack.nospace", new Object[0]));
                player.func_71053_j();
                return;
            }
            if (cap.hasWearable()) {
                cap.removeWearable();
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187728_s, SoundCategory.PLAYERS, 1.05f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                CapabilityUtils.synchronise(player);
                CapabilityUtils.synchroniseToOthers(player);
            }
            player.func_71053_j();
        }
    }

    public static void electrify(EntityPlayer player) {
        ItemStack stack;
        if (CapabilityUtils.isWearingBackpack(player) && ((stack = CapabilityUtils.getWearingBackpack(player)).func_77960_j() == 7 || stack.func_77960_j() == 53)) {
            ITravelersBackpack cap = CapabilityUtils.getCapability(player);
            ItemStack newStack = new ItemStack(ModItems.TRAVELERS_BACKPACK, 1, stack.func_77960_j() == 7 ? 24 : 51);
            newStack.func_77982_d(stack.func_77978_p());
            cap.removeWearable();
            cap.setWearable(newStack);
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_191263_gW, SoundCategory.MASTER, 1.0f, 1.0f);
            CapabilityUtils.synchronise(player);
            CapabilityUtils.synchroniseToOthers(player);
        }
    }

    public static void switchHoseMode(EntityPlayer player, int direction) {
        ItemStack hose = player.func_184614_ca();
        if (hose.func_77973_b() instanceof ItemHose && hose.func_77978_p() != null) {
            int mode = ItemHose.getHoseMode(hose);
            if (direction > 0) {
                if (++mode == 4) {
                    mode = 1;
                }
            } else if (direction < 0 && --mode == 0) {
                mode = 3;
            }
            hose.func_77978_p().func_74768_a("Mode", mode);
        }
    }

    public static void toggleHoseTank(EntityPlayer player) {
        ItemStack hose = player.func_184614_ca();
        if (hose.func_77973_b() instanceof ItemHose && hose.func_77978_p() != null) {
            int tank = ItemHose.getHoseTank(hose);
            tank = tank == 1 ? 2 : 1;
            hose.func_77978_p().func_74768_a("Tank", tank);
        }
    }
}

