/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.capability;

import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackCapability;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.gui.inventory.InventoryTravelersBackpack;
import com.tiviacz.travelersbackpack.handlers.ConfigHandler;
import com.tiviacz.travelersbackpack.items.ItemTravelersBackpack;
import com.tiviacz.travelersbackpack.util.Reference;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class CapabilityUtils {
    public static ITravelersBackpack getCapability(EntityPlayer player) {
        return (ITravelersBackpack)player.getCapability(TravelersBackpackCapability.TRAVELERS_BACKPACK_CAPABILITY, TravelersBackpackCapability.DEFAULT_FACING);
    }

    public static boolean isWearingBackpack(EntityPlayer player) {
        ITravelersBackpack cap = CapabilityUtils.getCapability(player);
        ItemStack backpack = cap.getWearable();
        return cap.hasWearable() && backpack.func_77973_b() instanceof ItemTravelersBackpack;
    }

    public static ItemStack getWearingBackpack(EntityPlayer player) {
        ITravelersBackpack cap = CapabilityUtils.getCapability(player);
        ItemStack backpack = cap.getWearable();
        return CapabilityUtils.isWearingBackpack(player) ? backpack : ItemStack.field_190927_a;
    }

    public static void synchronise(EntityPlayer player) {
        CapabilityUtils.getCapability(player).synchronise();
    }

    public static void synchroniseToOthers(EntityPlayer player) {
        CapabilityUtils.getCapability(player).synchroniseToOthers(player);
    }

    public static void equipBackpack(EntityPlayer player, ItemStack stack) {
        ITravelersBackpack cap = CapabilityUtils.getCapability(player);
        if (!player.field_70170_p.field_72995_K && !cap.hasWearable()) {
            cap.setWearable(stack);
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187728_s, SoundCategory.PLAYERS, 1.0f, (1.0f + (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            CapabilityUtils.synchronise(player);
            CapabilityUtils.synchroniseToOthers(player);
        }
    }

    public static void onEquippedUpdate(World world, EntityPlayer player, ItemStack stack) {
        if (!ConfigHandler.server.enableBackpackAbilities) {
            return;
        }
        if (world == null || player == null || stack == null) {
            return;
        }
        if (BackpackAbilities.hasItemAbility(Reference.BACKPACK_NAMES[stack.func_77960_j()])) {
            BackpackAbilities.backpackAbilities.executeItemAbility(player, world, stack);
        }
    }

    public static void onUnequipped(World world, EntityPlayer player, ItemStack stack) {
        if (BackpackAbilities.hasRemoval(Reference.BACKPACK_NAMES[stack.func_77960_j()])) {
            BackpackAbilities.backpackAbilities.executeRemoval(player, world, stack);
        }
    }

    public static InventoryTravelersBackpack getBackpackInv(EntityPlayer player) {
        ItemStack wearable = CapabilityUtils.getWearingBackpack(player);
        if (wearable.func_77973_b() instanceof ItemTravelersBackpack) {
            return new InventoryTravelersBackpack(wearable, player);
        }
        return null;
    }
}

