/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.util;

import java.util.List;
import java.util.Locale;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EnchantmentHelper {
    public static int getPlayerExperienceTotal(EntityPlayer player) {
        int experienceFromLevel = EnchantmentHelper.getExperienceFromLevel(player.field_71068_ca);
        int experienceBarCapacity = EnchantmentHelper.getExperienceBarCapacity(player.field_71068_ca);
        return (int)((float)experienceFromLevel + player.field_71106_cc * (float)experienceBarCapacity);
    }

    public static void adjustPlayerExperience(EntityPlayer player, int amount) {
        int experience = EnchantmentHelper.getPlayerExperienceTotal(player);
        player.field_71067_cb = Math.max(0, experience + amount);
        player.field_71068_ca = EnchantmentHelper.getLevelFromExperience(player.field_71067_cb);
        player.field_71106_cc = player.field_71067_cb - EnchantmentHelper.getExperienceFromLevel(player.field_71068_ca);
        player.field_71106_cc /= (float)EnchantmentHelper.getExperienceBarCapacity(player.field_71068_ca);
    }

    public static int getExperienceBarCapacity(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    private static int sum(long n, long a0, long d) {
        return (int)(n * (2L * a0 + (n - 1L) * d) / 2L);
    }

    public static int getExperienceFromLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return EnchantmentHelper.sum(level, 7L, 2L);
        }
        if (level <= 30) {
            return 315 + EnchantmentHelper.sum(level - 15, 37L, 5L);
        }
        return 1395 + EnchantmentHelper.sum(level - 30, 112L, 9L);
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    public static int getExperienceToNextLevel(int currentLevel) {
        return EnchantmentHelper.getExperienceToLevel(currentLevel, currentLevel + 1);
    }

    public static int getExperienceToLevel(int startingLevel, int targetLevel) {
        int startingLevelExperience = EnchantmentHelper.getExperienceFromLevel(targetLevel);
        int targetLevelExperience = EnchantmentHelper.getExperienceFromLevel(startingLevel);
        return startingLevelExperience - targetLevelExperience;
    }

    public static int getLevelFromExperience(int experience) {
        int level = 0;
        int experienceForNextLevel;
        while (experience >= (experienceForNextLevel = EnchantmentHelper.getExperienceToNextLevel(level))) {
            ++level;
            experience -= experienceForNextLevel;
        }
        return level;
    }

    public static String getExperienceString(int experience) {
        int level = EnchantmentHelper.getLevelFromExperience(experience);
        if (level == 0) {
            return experience + "xp";
        }
        int remainingExperience = experience - EnchantmentHelper.getExperienceFromLevel(level);
        if (remainingExperience == 0) {
            return level + "L";
        }
        float fraction = (float)remainingExperience / (float)EnchantmentHelper.getExperienceToNextLevel(level);
        return String.format(Locale.US, "%.2fL", Float.valueOf((float)level + fraction));
    }

    public static boolean isEnchantable(ItemStack itemStack) {
        boolean hasEnchantability = itemStack.func_77973_b().getItemEnchantability(itemStack) > 0;
        boolean isBook = itemStack.func_77973_b() == Items.field_151122_aG || itemStack.func_77973_b() == Items.field_151134_bR;
        return hasEnchantability && (isBook || itemStack.func_77956_u());
    }

    public static boolean isCompatible(Enchantment firstEnchantment, Enchantment secondEnchantment) {
        return firstEnchantment.func_191560_c(secondEnchantment);
    }

    public static float getEnchantPower(World world, BlockPos position) {
        float power = 0.0f;
        for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
            for (int offsetX = -1; offsetX <= 1; ++offsetX) {
                if (offsetZ == 0 && offsetX == 0 || !world.func_175623_d(position.func_177982_a(offsetX, 0, offsetZ)) || !world.func_175623_d(position.func_177982_a(offsetX, 1, offsetZ))) continue;
                power += ForgeHooks.getEnchantPower((World)world, (BlockPos)position.func_177982_a(offsetX * 2, 0, offsetZ * 2));
                power += ForgeHooks.getEnchantPower((World)world, (BlockPos)position.func_177982_a(offsetX * 2, 1, offsetZ * 2));
                if (offsetX == 0 || offsetZ == 0) continue;
                power += ForgeHooks.getEnchantPower((World)world, (BlockPos)position.func_177982_a(offsetX * 2, 0, offsetZ));
                power += ForgeHooks.getEnchantPower((World)world, (BlockPos)position.func_177982_a(offsetX * 2, 1, offsetZ));
                power += ForgeHooks.getEnchantPower((World)world, (BlockPos)position.func_177982_a(offsetX, 0, offsetZ * 2));
                power += ForgeHooks.getEnchantPower((World)world, (BlockPos)position.func_177982_a(offsetX, 1, offsetZ * 2));
            }
        }
        return power;
    }

    public static List<ItemStack> getAllBooksForEnchantment(Enchantment enchantment, List<ItemStack> result) {
        for (int i = enchantment.func_77319_d(); i <= enchantment.func_77325_b(); ++i) {
            result.add(ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(enchantment, i)));
        }
        return result;
    }
}

