/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.packer.atlas;

import com.codetaylor.mc.athenaeum.packer.atlas.Node;
import java.util.Deque;

class NodePool {
    private Deque<Node> availableNodePool;

    NodePool(Deque<Node> availableNodePool) {
        this.availableNodePool = availableNodePool;
    }

    Node getNode(Node parent, int posX, int posY, int width, int height) {
        if (this.availableNodePool.isEmpty()) {
            this.availableNodePool.add(new Node());
        }
        return this.availableNodePool.pop().init(parent, posX, posY, width, height);
    }

    void releaseNode(Node node) {
        if (node == null) {
            return;
        }
        if (node.childA != null) {
            this.releaseNode(node.childA);
        }
        if (node.childB != null) {
            this.releaseNode(node.childB);
        }
        node.initDefaults();
        this.availableNodePool.push(node);
    }
}

