/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.network.tile;

import com.codetaylor.mc.athenaeum.network.IPacketService;
import com.codetaylor.mc.athenaeum.network.tile.ITileDataService;
import com.codetaylor.mc.athenaeum.network.tile.SCPacketTileData;
import com.codetaylor.mc.athenaeum.network.tile.TileDataTracker;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.codetaylor.mc.athenaeum.network.tile.spi.TileEntityDataContainerBase;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileDataService
implements ITileDataService {
    private final int serviceId;
    private final IPacketService packetService;
    private final ThreadLocal<List<TileDataTracker>> dataTrackerList;
    private final ThreadLocal<Map<TileEntityDataContainerBase, TileDataTracker>> dataTrackerMap;

    public TileDataService(int serviceId, IPacketService packetService) {
        this.serviceId = serviceId;
        this.packetService = packetService;
        this.dataTrackerList = ThreadLocal.withInitial(ArrayList::new);
        this.dataTrackerMap = ThreadLocal.withInitial(IdentityHashMap::new);
    }

    @Override
    public int getServiceId() {
        return this.serviceId;
    }

    @Override
    @Nullable
    public TileDataTracker getTracker(TileEntityDataContainerBase tile) {
        return this.dataTrackerMap.get().get(tile);
    }

    @Override
    public void register(TileEntityDataContainerBase tile, ITileData[] data) {
        if (data.length > 0) {
            Map<TileEntityDataContainerBase, TileDataTracker> map = this.dataTrackerMap.get();
            TileDataTracker tracker = map.get(tile);
            if (tracker == null) {
                tracker = new TileDataTracker(tile);
                this.dataTrackerList.get().add(tracker);
                map.put(tile, tracker);
            }
            tracker.addTileData(data);
        }
    }

    @Override
    public void update() {
        List<TileDataTracker> trackers = this.dataTrackerList.get();
        for (int i = 0; i < trackers.size(); ++i) {
            PacketBuffer updateBuffer;
            TileDataTracker tracker = trackers.get(i);
            TileEntityDataContainerBase tile = tracker.getTile();
            if (tile.func_145837_r()) {
                trackers.set(i, trackers.get(trackers.size() - 1));
                trackers.remove(trackers.size() - 1);
                this.dataTrackerMap.get().remove(tile);
                --i;
                continue;
            }
            if (tile.func_145831_w() == null || (updateBuffer = tracker.getUpdateBuffer()).writerIndex() <= 0) continue;
            SCPacketTileData packet = new SCPacketTileData(this.serviceId, tile.func_174877_v(), updateBuffer);
            this.packetService.sendToDimension((IMessage)packet, tile);
        }
    }
}

