/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.inventory;

import com.codetaylor.mc.athenaeum.inventory.IObservableEnergyStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class ObservableEnergyStorage
extends EnergyStorage
implements IObservableEnergyStorage,
INBTSerializable<NBTTagCompound> {
    private List<IObservableEnergyStorage.IContentsChangedEventHandler> eventHandlerList = new ArrayList<IObservableEnergyStorage.IContentsChangedEventHandler>();

    public ObservableEnergyStorage(int capacity) {
        this(capacity, capacity, capacity, 0);
    }

    public ObservableEnergyStorage(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, 0);
    }

    public ObservableEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        this(capacity, maxReceive, maxExtract, 0);
    }

    public ObservableEnergyStorage(int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
    }

    @Override
    public void addObserver(IObservableEnergyStorage.IContentsChangedEventHandler handler) {
        this.eventHandlerList.add(handler);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
            this.onContentsChanged(energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
            this.onContentsChanged(-energyExtracted);
        }
        return energyExtracted;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("energy", this.energy);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.energy = Math.min(this.capacity, nbt.func_74762_e("energy"));
    }

    protected void onContentsChanged(int amount) {
        if (amount != 0 && !this.eventHandlerList.isEmpty()) {
            for (IObservableEnergyStorage.IContentsChangedEventHandler handler : this.eventHandlerList) {
                handler.onContentsChanged((IEnergyStorage)this, amount);
            }
        }
    }
}

