/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.interaction.spi;

import com.codetaylor.mc.athenaeum.integration.gamestages.GameStages;
import com.codetaylor.mc.athenaeum.integration.gamestages.Stages;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.interaction.util.InteractionRayTraceData;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public interface ITileInteractable {
    public static final IInteraction[] EMPTY_INTERACTION_HANDLERS = new IInteraction[0];

    default public IInteraction[] getInteractions() {
        return EMPTY_INTERACTION_HANDLERS;
    }

    default public int getInteractionCooldown() {
        return 0;
    }

    default public boolean isExtendedInteraction(World world, BlockPos pos, IBlockState blockState) {
        return false;
    }

    default public EnumFacing getTileFacing(World world, BlockPos pos, IBlockState blockState) {
        return EnumFacing.NORTH;
    }

    default public boolean allowInteractionWithPlayer(EntityPlayer player) {
        if (Loader.isModLoaded((String)"gamestages")) {
            return GameStages.allowed(player, this.getStages());
        }
        return true;
    }

    @Nullable
    default public Stages getStages() {
        return null;
    }

    default public <T extends TileEntity> void interact(IInteraction.EnumType type, T tile, World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!this.allowInteractionWithPlayer(player)) {
            return;
        }
        Vec3d posVec = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        int interactionDistance = 5;
        RayTraceResult rayTraceResult = world.func_72901_a(posVec, posVec.func_178787_e(player.func_70040_Z().func_186678_a((double)interactionDistance)), false);
        if (rayTraceResult != null && rayTraceResult.hitInfo instanceof InteractionRayTraceData.List) {
            InteractionRayTraceData data;
            IInteraction interaction;
            if (!rayTraceResult.func_178782_a().equals((Object)pos) && !((ITileInteractable)tile).isExtendedInteraction(world, rayTraceResult.func_178782_a(), state)) {
                return;
            }
            InteractionRayTraceData.List results = (InteractionRayTraceData.List)rayTraceResult.hitInfo;
            for (int i = 0; !(i >= results.size() || (interaction = (data = (InteractionRayTraceData)results.get(i)).getInteraction()).allowInteractionWithHand(hand) && interaction.allowInteractionWithSide(data.getRayTraceResult().field_178784_b) && interaction.interact(type, tile, world, pos, state, player, hand, facing, hitX, hitY, hitZ)); ++i) {
            }
        }
    }

    default public <T extends TileEntity> T asTileInteractable() {
        return (T)((TileEntity)this);
    }
}

