/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.interaction.spi;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IInteraction<T extends TileEntity> {
    default public boolean isEnabled() {
        return true;
    }

    public AxisAlignedBB getInteractionBounds(World var1, BlockPos var2, IBlockState var3);

    default public boolean allowInteractionWithHand(EnumHand hand) {
        return hand == EnumHand.MAIN_HAND;
    }

    default public boolean allowInteractionWithType(EnumType type) {
        return true;
    }

    public boolean allowInteractionWithSide(EnumFacing var1);

    public boolean interact(EnumType var1, T var2, World var3, BlockPos var4, IBlockState var5, EntityPlayer var6, EnumHand var7, EnumFacing var8, float var9, float var10, float var11);

    @SideOnly(value=Side.CLIENT)
    default public void renderSolidPass(World world, RenderItem renderItem, BlockPos pos, IBlockState blockState, float partialTicks) {
    }

    @SideOnly(value=Side.CLIENT)
    default public void renderSolidPassText(World world, FontRenderer fontRenderer, int yaw, Vec3d offset, BlockPos pos, IBlockState blockState, float partialTicks) {
    }

    default public Vec3d getTextOffset(EnumFacing tileFacing, EnumFacing playerHorizontalFacing, EnumFacing sideHit) {
        return Vec3d.field_186680_a;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean renderAdditivePass(World world, RenderItem renderItem, EnumFacing hitSide, Vec3d hitVec, BlockPos hitPos, IBlockState blockState, ItemStack heldItemMainHand, float partialTicks) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean forceRenderAdditivePassWhileSneaking() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean shouldRenderAdditivePassForHeldItem(ItemStack heldItemMainHand) {
        return !heldItemMainHand.func_190926_b();
    }

    public static enum EnumType {
        MouseClick,
        MouseWheelUp,
        MouseWheelDown;

    }
}

