/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.integration.crafttweaker.mtlib.helpers;

import com.codetaylor.mc.athenaeum.integration.crafttweaker.mtlib.helpers.CTInputHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.CrafttweakerImplementationAPI;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.oredict.IOreDictEntry;
import crafttweaker.api.player.IPlayer;
import crafttweaker.mc1120.item.MCItemStack;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class CTLogHelper {
    public static void logPrinted(IPlayer player) {
        if (player != null) {
            player.sendChat(CrafttweakerImplementationAPI.platform.getMessage("List generated; see minetweaker.log in your minecraft dir"));
        }
    }

    public static void log(IPlayer player, String message) {
        if (player != null) {
            player.sendChat(CrafttweakerImplementationAPI.platform.getMessage(message));
        }
    }

    public static void print(String string) {
        System.out.println(string);
        CraftTweakerAPI.logCommand((String)string);
    }

    public static void logError(String message) {
        CraftTweakerAPI.logError((String)message);
    }

    public static void logError(String message, Throwable exception) {
        CraftTweakerAPI.logError((String)message, (Throwable)exception);
    }

    public static void logErrorFromZenMethod(String message) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            String methodName = element.getMethodName();
            if (!"__script__".equals(methodName)) continue;
            CraftTweakerAPI.logError((String)(message + " (" + element.getFileName() + ":" + element.getLineNumber() + ")"));
            break;
        }
    }

    public static void logWarning(String message) {
        CraftTweakerAPI.logWarning((String)message);
    }

    public static void logInfo(String message) {
        CraftTweakerAPI.logInfo((String)message);
    }

    public static String getStackDescription(Object object) {
        if (object instanceof IIngredient) {
            return CTLogHelper.getStackDescription((IIngredient)object);
        }
        if (object instanceof ItemStack) {
            return new MCItemStack((ItemStack)object).toString();
        }
        if (object instanceof FluidStack) {
            return CTLogHelper.getStackDescription((FluidStack)object);
        }
        if (object instanceof Block) {
            return new MCItemStack(new ItemStack((Block)object, 1, 0)).toString();
        }
        if (object instanceof String) {
            NonNullList ores = OreDictionary.getOres((String)((String)object));
            if (!ores.isEmpty()) {
                return "<ore:" + (String)object + ">";
            }
            return "\"" + (String)object + "\"";
        }
        if (object instanceof List) {
            return CTLogHelper.getListDescription((List)object);
        }
        if (object instanceof Object[]) {
            return CTLogHelper.getListDescription(Arrays.asList((Object[])object));
        }
        if (object != null) {
            return "\"" + object.toString() + "\"";
        }
        if (object instanceof Ingredient && !((Ingredient)object).apply(ItemStack.field_190927_a) && ((Ingredient)object).func_193365_a().length > 0) {
            return CTLogHelper.getStackDescription(((Ingredient)object).func_193365_a()[0]);
        }
        return "null";
    }

    public static String getStackDescription(IIngredient stack) {
        Object internalObject = stack.getInternal();
        if (internalObject instanceof ItemStack) {
            return CTLogHelper.getStackDescription((ItemStack)internalObject);
        }
        if (internalObject instanceof FluidStack) {
            return CTLogHelper.getStackDescription((FluidStack)internalObject);
        }
        if (internalObject instanceof IOreDictEntry) {
            return CTLogHelper.getStackDescription(((IOreDictEntry)internalObject).getName());
        }
        return "null";
    }

    public static String getStackDescription(FluidStack stack) {
        StringBuilder sb = new StringBuilder();
        sb.append("<liquid:").append(stack.getFluid().getName()).append('>');
        if (stack.amount > 1) {
            sb.append(" * ").append(stack.amount);
        }
        return sb.toString();
    }

    public static String getListDescription(List<?> objects) {
        StringBuilder sb = new StringBuilder();
        if (objects.isEmpty()) {
            sb.append("[]");
        } else {
            sb.append('[');
            for (Object object : objects) {
                if (object instanceof List) {
                    sb.append(CTLogHelper.getListDescription((List)object)).append(", ");
                    continue;
                }
                if (object instanceof Object[]) {
                    sb.append(CTLogHelper.getListDescription(Arrays.asList((Object[])object))).append(", ");
                    continue;
                }
                sb.append(CTLogHelper.getStackDescription(object)).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(']');
        }
        return sb.toString();
    }

    public static String getCraftingDescription(IRecipe recipe) {
        if (recipe instanceof ShapelessOreRecipe) {
            return CTLogHelper.getCraftingDescription((ShapelessOreRecipe)recipe);
        }
        if (recipe instanceof ShapedOreRecipe) {
            return CTLogHelper.getCraftingDescription((ShapedOreRecipe)recipe);
        }
        if (recipe instanceof ShapelessRecipes) {
            return CTLogHelper.getCraftingDescription((ShapelessRecipes)recipe);
        }
        if (recipe instanceof ShapedRecipes) {
            return CTLogHelper.getCraftingDescription((ShapedRecipes)recipe);
        }
        return recipe.toString();
    }

    public static String getCraftingDescription(ShapelessOreRecipe recipe) {
        return CTLogHelper.getListDescription(recipe.func_192400_c());
    }

    public static String getCraftingDescription(ShapelessRecipes recipe) {
        return CTLogHelper.getListDescription(recipe.field_77579_b);
    }

    public static String getCraftingDescription(ShapedOreRecipe recipe) {
        int height = recipe.getWidth();
        int width = recipe.getHeight();
        Ingredient[][] recipes = (Ingredient[][])CTInputHelper.getMultiDimensionalArray(Ingredient.class, recipe.func_192400_c().toArray((Object[])new Ingredient[0]), height, width);
        return CTLogHelper.getListDescription(Arrays.asList(recipes));
    }

    public static String getCraftingDescription(ShapedRecipes recipe) {
        Ingredient[][] recipes = (Ingredient[][])CTInputHelper.getMultiDimensionalArray(Ingredient.class, recipe.func_192400_c().toArray((Object[])new Ingredient[0]), recipe.field_77577_c, recipe.field_77576_b);
        return CTLogHelper.getListDescription(Arrays.asList(recipes));
    }
}

