/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.gui.element;

import com.codetaylor.mc.athenaeum.gui.GuiContainerBase;
import com.codetaylor.mc.athenaeum.gui.element.GuiElementTiledTextureAtlasSpriteBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public abstract class GuiElementFluidTankBase
extends GuiElementTiledTextureAtlasSpriteBase {
    protected final FluidTank fluidTank;
    private TextureAtlasSprite fluidSprite;

    public GuiElementFluidTankBase(GuiContainerBase guiBase, int elementX, int elementY, int elementWidth, int elementHeight, FluidTank fluidTank) {
        super(guiBase, elementX, elementY, elementWidth, elementHeight);
        this.fluidTank = fluidTank;
    }

    protected float scalarPercentageGet() {
        int fluidAmount = this.fluidTank.getFluidAmount();
        if (fluidAmount > 0) {
            int capacity = this.fluidTank.getCapacity();
            return Math.max((float)fluidAmount / (float)capacity, 1.0f / (float)this.elementHeight);
        }
        return 0.0f;
    }

    @Override
    protected TextureAtlasSprite textureAtlasSpriteGet() {
        FluidStack fluidStack = this.fluidTank.getFluid();
        if (fluidStack == null) {
            this.fluidSprite = null;
        } else if (this.fluidSprite == null) {
            ResourceLocation resourceLocation = fluidStack.getFluid().getStill();
            this.fluidSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(resourceLocation.toString());
        }
        return this.fluidSprite;
    }

    @Override
    public void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        FluidStack fluid = this.fluidTank.getFluid();
        if (fluid != null) {
            int color = fluid.getFluid().getColor();
            GlStateManager.func_179131_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
        }
        super.drawBackgroundLayer(partialTicks, mouseX, mouseY);
        if (fluid != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

