/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.gui;

import com.codetaylor.mc.athenaeum.gui.SlotMovable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class ContainerBase
extends Container {
    protected static final int NO_SLOT_TARGET_INDEX = -1;
    protected static final int DEFAULT_HOTBAR_POSITION_X = 8;
    protected static final int DEFAULT_HOTBAR_POSITION_Y = 142;
    protected static final int DEFAULT_INVENTORY_POSITION_X = 8;
    protected static final int DEFAULT_INVENTORY_POSITION_Y = 84;
    protected static final int DEFAULT_SLOT_SPACING_X = 18;
    protected static final int DEFAULT_SLOT_SPACING_Y = 18;
    protected InventoryPlayer inventoryPlayer;
    protected int nextSlotIndex;
    protected int playerInventorySlotIndexStart;
    protected int playerHotbarSlotIndexStart;

    public ContainerBase(InventoryPlayer inventoryPlayer) {
        this.inventoryPlayer = inventoryPlayer;
        this.nextSlotIndex = 0;
    }

    protected int containerPlayerInventoryAdd() {
        this.playerInventorySlotIndexStart = this.nextSlotIndex;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int xPosition = this.containerInventoryPositionGetX() + x * this.containerSlotSpacingGetX();
                int yPosition = this.containerInventoryPositionGetY() + y * this.containerSlotSpacingGetY();
                this.func_75146_a(new SlotMovable((IInventory)this.inventoryPlayer, x + y * 9 + 9, xPosition, yPosition));
            }
        }
        return this.nextSlotIndex - 1;
    }

    protected int containerPlayerHotbarAdd() {
        this.playerHotbarSlotIndexStart = this.nextSlotIndex;
        for (int x = 0; x < 9; ++x) {
            int xPosition = this.containerHotbarPositionGetX() + this.containerSlotSpacingGetX() * x;
            int yPosition = this.containerHotbarPositionGetY();
            this.func_75146_a(new SlotMovable((IInventory)this.inventoryPlayer, x, xPosition, yPosition));
        }
        return this.nextSlotIndex - 1;
    }

    protected int containerSlotAdd(Slot slot) {
        super.func_75146_a(slot);
        ++this.nextSlotIndex;
        return this.nextSlotIndex - 1;
    }

    protected Slot func_75146_a(Slot slotIn) {
        ++this.nextSlotIndex;
        return super.func_75146_a(slotIn);
    }

    protected int containerSlotSpacingGetX() {
        return 18;
    }

    protected int containerSlotSpacingGetY() {
        return 18;
    }

    protected int containerHotbarPositionGetX() {
        return 8;
    }

    protected int containerHotbarPositionGetY() {
        return 142;
    }

    protected int containerInventoryPositionGetX() {
        return 8;
    }

    protected int containerInventoryPositionGetY() {
        return 84;
    }

    protected boolean containerSlotIsPlayerInventory(int slotIndex) {
        return slotIndex >= this.playerInventorySlotIndexStart && slotIndex < this.playerInventorySlotIndexStart + 27;
    }

    protected boolean containerSlotIsPlayerHotbar(int slotIndex) {
        return slotIndex >= this.playerHotbarSlotIndexStart && slotIndex < this.playerHotbarSlotIndexStart + 9;
    }

    protected boolean containerShiftClickEnabled() {
        return true;
    }

    @Nullable
    protected Slot containerItemStackSlotTargetGet(ItemStack itemStack) {
        return null;
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        if (!this.containerShiftClickEnabled()) {
            return null;
        }
        ItemStack itemStackResult = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemStack = slot.func_75211_c();
            itemStackResult = itemStack.func_77946_l();
            if (!this.containerSlotItemStackMerge(slotIndex, itemStackResult, slot, itemStack)) {
                return null;
            }
            if (itemStack.func_190916_E() <= 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemStack.func_190916_E() == itemStackResult.func_190916_E()) {
                return null;
            }
            slot.func_190901_a(player, itemStack);
        }
        return itemStackResult;
    }

    private boolean containerSlotItemStackMerge(int slotIndex, ItemStack itemStackResult, Slot slot, ItemStack itemStack) {
        if (!this.containerSlotIsPlayerInventory(slotIndex) && !this.containerSlotIsPlayerHotbar(slotIndex)) {
            if (this.func_75135_a(itemStack, 0, 36, true)) {
                slot.func_75220_a(itemStack, itemStackResult);
                return true;
            }
        } else {
            Slot targetSlot = this.containerItemStackSlotTargetGet(itemStack);
            if (targetSlot != null) {
                int index = this.containerSlotIndexGet(targetSlot);
                if (index == -1) {
                    throw new RuntimeException();
                }
                if (this.func_75135_a(itemStack, index, index + 1, false)) {
                    return true;
                }
            } else if (this.containerSlotIsPlayerInventory(slotIndex) ? this.func_75135_a(itemStack, this.playerHotbarSlotIndexStart, this.playerHotbarSlotIndexStart + 9, false) : this.func_75135_a(itemStack, this.playerInventorySlotIndexStart, this.playerInventorySlotIndexStart + 27, false)) {
                return true;
            }
        }
        return false;
    }

    private int containerSlotIndexGet(Slot targetSlot) {
        int index = -1;
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            if (targetSlot != this.field_75151_b.get(i)) continue;
            index = i;
            break;
        }
        return index;
    }

    protected void containerInventoryShow() {
        for (int i = this.playerInventorySlotIndexStart; i < this.playerInventorySlotIndexStart + 27; ++i) {
            List inventorySlots = this.field_75151_b;
            Slot slot = (Slot)inventorySlots.get(i);
            if (!(slot instanceof SlotMovable)) continue;
            ((SlotMovable)slot).slotMoveToOrigin();
        }
    }

    protected void containerHotbarShow() {
        for (int i = this.playerHotbarSlotIndexStart; i < this.playerHotbarSlotIndexStart + 9; ++i) {
            List inventorySlots = this.field_75151_b;
            Slot slot = (Slot)inventorySlots.get(i);
            if (!(slot instanceof SlotMovable)) continue;
            ((SlotMovable)slot).slotMoveToOrigin();
        }
    }

    protected void containerInventoryHide() {
        for (int i = this.playerInventorySlotIndexStart; i < this.playerInventorySlotIndexStart + 27; ++i) {
            List inventorySlots = this.field_75151_b;
            Slot slot = (Slot)inventorySlots.get(i);
            if (!(slot instanceof SlotMovable)) continue;
            ((SlotMovable)slot).slotMove(-30000, -30000);
        }
    }

    protected void containerHotbarHide() {
        for (int i = this.playerHotbarSlotIndexStart; i < this.playerHotbarSlotIndexStart + 9; ++i) {
            List inventorySlots = this.field_75151_b;
            Slot slot = (Slot)inventorySlots.get(i);
            if (!(slot instanceof SlotMovable)) continue;
            ((SlotMovable)slot).slotMove(-30000, -30000);
        }
    }
}

