/*
 * Decompiled with CFR 0.152.
 */
package omtteam.openmodularturrets.client.gui;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import omtteam.omlib.api.gui.BlockingAbstractGuiContainer;
import omtteam.omlib.api.gui.GuiParameters;
import omtteam.omlib.api.gui.IHasTooltips;
import omtteam.omlib.api.gui.ISupportsBackSystem;
import omtteam.omlib.api.permission.IHasOwner;
import omtteam.omlib.api.permission.TrustedPlayer;
import omtteam.omlib.network.OMLibNetworkingHandler;
import omtteam.omlib.network.messages.MessageCloseGUITile;
import omtteam.omlib.network.messages.MessageOpenGUITile;
import omtteam.omlib.util.DebugHandler;
import omtteam.omlib.util.EnumMachineMode;
import omtteam.omlib.util.GeneralUtil;
import omtteam.omlib.util.WorldUtil;
import omtteam.omlib.util.player.PlayerUtil;
import omtteam.openmodularturrets.OpenModularTurrets;
import omtteam.openmodularturrets.client.gui.containers.TurretBaseContainer;
import omtteam.openmodularturrets.handler.OMTNetworkingHandler;
import omtteam.openmodularturrets.network.messages.MessageAdjustMaxRange;
import omtteam.openmodularturrets.network.messages.MessageDropBase;
import omtteam.openmodularturrets.network.messages.MessageDropTurrets;
import omtteam.openmodularturrets.network.messages.MessageSetBaseTargetingType;
import omtteam.openmodularturrets.network.messages.MessageToggleMode;
import omtteam.openmodularturrets.tileentity.TurretBase;
import omtteam.openmodularturrets.tileentity.turrets.TurretHead;
import omtteam.openmodularturrets.util.TurretHeadUtil;
import org.lwjgl.opengl.GL11;

public class TurretBaseGui
extends BlockingAbstractGuiContainer
implements IHasTooltips,
ISupportsBackSystem {
    private final TurretBase base;
    private final EntityPlayer player;
    private int mouseX;
    private int mouseY;
    private int accessLevel = 0;
    private boolean addedToSyncList;

    public TurretBaseGui(InventoryPlayer inventoryPlayer, TurretBase turretBase) {
        super((Container)new TurretBaseContainer(inventoryPlayer, turretBase));
        this.base = turretBase;
        this.player = inventoryPlayer.field_70458_d;
        DebugHandler.getInstance().setPlayer(this.player);
    }

    protected void drawEnergyBar() {
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        int expression = this.base.getEnergyStored(EnumFacing.DOWN) * 51 / (this.base.getMaxEnergyStored(EnumFacing.DOWN) == 0 ? 1 : this.base.getMaxEnergyStored(EnumFacing.DOWN));
        this.func_73729_b(x + 153, y + 17, 178, 17, 14, 51);
        int next = new Random().nextInt(3);
        if (next == 0) {
            this.func_73729_b(x + 153, y + 17 + 51 - expression, 196, 68 - expression, 14, expression);
        }
        if (next == 1) {
            this.func_73729_b(x + 153, y + 17 + 51 - expression, 215, 68 - expression, 14, expression);
        }
        if (next == 2) {
            this.func_73729_b(x + 153, y + 17 + 51 - expression, 234, 68 - expression, 14, expression);
        }
    }

    protected void buttonInit() {
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.clear();
        if (PlayerUtil.isPlayerAdmin((EntityPlayer)this.player, (IHasOwner)this.base)) {
            this.field_146292_n.add(new GuiButton(3, x + 180, y + 100, 80, 20, GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:drop_turrets")));
            this.field_146292_n.add(new GuiButton(4, x + 180, y + 75, 80, 20, GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:drop_base")));
            this.field_146292_n.add(new GuiButton(5, x + 180, y + 25, 80, 20, GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:configure")));
            this.field_146292_n.add(new GuiButton(6, x + 180, y + 50, 80, 20, this.base.isMultiTargeting() ? GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:target") + ": " + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:multi") : GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:target") + ": " + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:single")));
            this.field_146292_n.add(new GuiButton(7, x + 180, y, 80, 20, GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:mode")));
            this.field_146292_n.add(new GuiButton(1, x + 120, y + 15, 20, 20, "+"));
            this.field_146292_n.add(new GuiButton(2, x + 120, y + 50, 20, 20, "-"));
        } else if (PlayerUtil.canPlayerChangeSetting((EntityPlayer)this.player, (IHasOwner)this.base)) {
            this.field_146292_n.add(new GuiButton(5, x + 180, y + 25, 80, 20, GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:configure")));
            this.field_146292_n.add(new GuiButton(6, x + 180, y + 50, 80, 20, this.base.isMultiTargeting() ? GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:target") + ": " + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:multi") : GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:target") + ": " + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:single")));
            this.field_146292_n.add(new GuiButton(1, x + 120, y + 15, 20, 20, "+"));
            this.field_146292_n.add(new GuiButton(2, x + 120, y + 50, 20, 20, "-"));
        }
    }

    public void func_73866_w_() {
        this.buttonInit();
        if (!this.addedToSyncList) {
            OMLibNetworkingHandler.INSTANCE.sendToServer((IMessage)new MessageOpenGUITile((TileEntity)this.base));
            this.addedToSyncList = true;
        }
        this.accessLevel = PlayerUtil.getPlayerAccessLevel((EntityPlayer)this.player, (IHasOwner)this.base).ordinal();
        if (this.accessLevel == 0) {
            this.player.func_71053_j();
        }
        super.func_73866_w_();
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.mouseX = par1;
        this.mouseY = par2;
        this.func_146276_q_();
        if (this.accessLevel != PlayerUtil.getPlayerAccessLevel((EntityPlayer)this.player, (IHasOwner)this.base).ordinal()) {
            this.accessLevel = PlayerUtil.getPlayerAccessLevel((EntityPlayer)this.player, (IHasOwner)this.base).ordinal();
            if (this.accessLevel != 0) {
                this.func_73866_w_();
            }
        } else if (!PlayerUtil.isPlayerOwner((EntityPlayer)this.player, (IHasOwner)this.base) && this.accessLevel == 0) {
            this.player.func_71053_j();
        }
        super.func_73863_a(par1, par2, par3);
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton.field_146127_k == 1) {
            this.base.setCurrentMaxRange(this.base.getCurrentMaxRange() + 1);
            this.sendChangeToServer();
        }
        if (guibutton.field_146127_k == 2) {
            this.base.setCurrentMaxRange(this.base.getCurrentMaxRange() - 1);
            this.sendChangeToServer();
        }
        if (guibutton.field_146127_k == 3) {
            this.sendDropTurretsToServer();
        }
        if (guibutton.field_146127_k == 4) {
            this.sendDropBaseToServer();
        }
        if (guibutton.field_146127_k == 5) {
            this.player.openGui((Object)OpenModularTurrets.instance, 20, this.player.func_130014_f_(), this.base.func_174877_v().func_177958_n(), this.base.func_174877_v().func_177956_o(), this.base.func_174877_v().func_177952_p());
        }
        if (guibutton.field_146127_k == 6) {
            this.sendSetBaseTargetingToServer();
            for (Object button : this.field_146292_n) {
                if (((GuiButton)button).field_146127_k != 6) continue;
                this.base.setMultiTargeting(!this.base.isMultiTargeting());
                ((GuiButton)button).field_146126_j = this.base.isMultiTargeting() ? GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:target") + ": " + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:multi") : GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:target") + ": " + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:single");
            }
        }
        if (guibutton.field_146127_k == 7) {
            this.sendToggleModeToServer();
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (this.base.getTier()) {
            case 1: {
                this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("openmodularturrets:textures/gui/turret_base_tier_one.png"));
                break;
            }
            case 2: {
                this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("openmodularturrets:textures/gui/turret_base_tier_two.png"));
                break;
            }
            case 3: {
                this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("openmodularturrets:textures/gui/turret_base_tier_three.png"));
                break;
            }
            case 4: {
                this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("openmodularturrets:textures/gui/turret_base_tier_four.png"));
                break;
            }
            case 5: {
                this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation("openmodularturrets:textures/gui/turret_base_tier_five.png"));
            }
        }
        this.drawEnergyBar();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_78276_b(this.base.getTier() > 1 ? GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:addons") : "", 71, 6, 0);
        fontRenderer.func_78276_b(this.base.getTier() > 1 ? GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:upgrades") : "", 71, 39, 0);
        fontRenderer.func_78276_b(GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:ammo"), 8, 6, 0);
        fontRenderer.func_78276_b(GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:inventory"), 8, this.field_147000_g - 97 + 4, 0);
        fontRenderer.func_175063_a("" + this.base.getCurrentMaxRange(), String.valueOf(this.base.getCurrentMaxRange()).length() == 1 ? 127.0f : 124.0f, 39.0f, this.base.getCurrentMaxRange() == this.getBaseUpperBoundRange() ? 0xFF3232 : 40000);
        fontRenderer.func_78276_b(GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:range"), 116, 6, 0);
        ArrayList<String> targetInfo = new ArrayList<String>();
        targetInfo.add("\u00a76" + GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:owner") + ": \u00a7f" + this.base.getOwner().getName());
        targetInfo.add("\u00a76" + GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:mode") + ": \u00a7f" + GeneralUtil.getMachineModeLocalization((EnumMachineMode)this.base.getMode()));
        boolean isCurrentlyOn = this.base.isActive();
        targetInfo.add("\u00a76" + GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:active") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo((boolean)isCurrentlyOn));
        targetInfo.add("");
        targetInfo.add("\u00a76" + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:kills") + ": " + this.base.getKills());
        targetInfo.add("\u00a76" + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:player_kills") + ": " + this.base.getPlayerKills());
        targetInfo.add("");
        if (this.base.getTrustManager().getTrustedPlayers().size() != 0) {
            targetInfo.add("\u00a75" + GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:trusted_players") + ":");
            for (TrustedPlayer trusted_player : this.base.getTrustManager().getTrustedPlayers()) {
                targetInfo.add("\u00a7b" + trusted_player.getName());
            }
        } else {
            targetInfo.add("\u00a75" + GeneralUtil.safeLocalize((String)"gui.omtteam.omlib:trusted_players") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo((boolean)false));
        }
        targetInfo.add("");
        targetInfo.add("\u00a77" + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:attack_mobs") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo((boolean)this.base.isAttacksMobs()));
        targetInfo.add("\u00a77" + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:attack_neutrals") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo((boolean)this.base.isAttacksNeutrals()));
        targetInfo.add("\u00a77" + GeneralUtil.safeLocalize((String)"gui.omtteam.openmodularturrets:attack_players") + ": " + GeneralUtil.getColoredBooleanLocalizationYesNo((boolean)this.base.isAttacksPlayers()));
        this.drawHoveringText(targetInfo, -128, 17, fontRenderer);
        super.func_146979_b(mouseX, mouseY);
        this.drawTooltips();
    }

    public void drawTooltips() {
        Slot slot;
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        int tooltipToDraw = this.field_146292_n.stream().filter(GuiButton::func_146115_a).mapToInt(s -> s.field_146127_k).sum();
        ArrayList<String> tooltip = new ArrayList<String>();
        switch (tooltipToDraw) {
            case 1: {
                tooltip.add(GeneralUtil.safeLocalize((String)"tooltip.omtteam.openmodularturrets:plus_range"));
                break;
            }
            case 2: {
                tooltip.add(GeneralUtil.safeLocalize((String)"tooltip.omtteam.openmodularturrets:minus_range"));
                break;
            }
            case 5: {
                tooltip.add(GeneralUtil.safeLocalize((String)"tooltip.omtteam.openmodularturrets:configure_base"));
                break;
            }
            case 6: {
                tooltip.add(GeneralUtil.safeLocalize((String)"tooltip.omtteam.openmodularturrets:multi_targeting"));
                break;
            }
            case 7: {
                tooltip.add(GeneralUtil.safeLocalize((String)"tooltip.omtteam.openmodularturrets:toggle_mode"));
            }
        }
        if (this.mouseX > k + 153 && this.mouseX < k + 153 + 14 && this.mouseY > l + 17 && this.mouseY < l + 17 + 51) {
            tooltip.add(this.base.getEnergyStored(EnumFacing.DOWN) + "/" + this.base.getMaxEnergyStored(EnumFacing.DOWN) + " RF");
        }
        if (this.base.getTier() > 1 && this.mouseX > k + 71 && this.mouseX < k + 71 + 40 && this.mouseY > l + 6 && this.mouseY < l + 6 + 14) {
            tooltip.add(GeneralUtil.safeLocalize((String)"tooltip.omtteam.openmodularturrets:addon_slot"));
        }
        if (this.base.getTier() > 1 && this.mouseX > k + 71 && this.mouseX < k + 71 + 40 && this.mouseY > l + 39 && this.mouseY < l + 39 + 14) {
            tooltip.add(GeneralUtil.safeLocalize((String)"tooltip.omtteam.openmodularturrets:upgrade_slot"));
        }
        if (this.mouseX > k + 10 && this.mouseX < k + 8 + 40 && this.mouseY > l + 6 && this.mouseY < l + 6 + 14) {
            tooltip.add(GeneralUtil.safeLocalize((String)"tooltip.omtteam.openmodularturrets:ammo_slot"));
        }
        if (this.mouseX > k + 123 && this.mouseX < k + 134 && this.mouseY > l + 35 && this.mouseY < l + 48) {
            tooltip.add(GeneralUtil.safeLocalize((String)"tooltip.omtteam.openmodularturrets:base_max_range"));
        }
        if ((slot = this.getSlotUnderMouse()) != null && !slot.func_75211_c().func_190926_b()) {
            ItemStack stack = slot.func_75211_c();
            this.func_146285_a(stack, this.mouseX - this.field_147003_i, this.mouseY - this.field_147009_r);
        }
        if (!tooltip.isEmpty()) {
            this.drawHoveringText(tooltip, this.mouseX - k, this.mouseY - l, Minecraft.func_71410_x().field_71466_p);
        }
    }

    private void sendChangeToServer() {
        MessageAdjustMaxRange message = new MessageAdjustMaxRange(this.base.func_174877_v().func_177958_n(), this.base.func_174877_v().func_177956_o(), this.base.func_174877_v().func_177952_p(), this.base.getCurrentMaxRange());
        OMTNetworkingHandler.INSTANCE.sendToServer((IMessage)message);
    }

    private void sendDropTurretsToServer() {
        MessageDropTurrets message = new MessageDropTurrets(this.base.func_174877_v().func_177958_n(), this.base.func_174877_v().func_177956_o(), this.base.func_174877_v().func_177952_p());
        OMTNetworkingHandler.INSTANCE.sendToServer((IMessage)message);
    }

    private void sendDropBaseToServer() {
        this.player.func_71053_j();
        MessageDropBase message = new MessageDropBase(this.base.func_174877_v().func_177958_n(), this.base.func_174877_v().func_177956_o(), this.base.func_174877_v().func_177952_p());
        OMTNetworkingHandler.INSTANCE.sendToServer((IMessage)message);
    }

    private void sendSetBaseTargetingToServer() {
        MessageSetBaseTargetingType message = new MessageSetBaseTargetingType(this.base.func_174877_v().func_177958_n(), this.base.func_174877_v().func_177956_o(), this.base.func_174877_v().func_177952_p());
        OMTNetworkingHandler.INSTANCE.sendToServer((IMessage)message);
    }

    private void sendToggleModeToServer() {
        MessageToggleMode message = new MessageToggleMode(this.base.func_174877_v().func_177958_n(), this.base.func_174877_v().func_177956_o(), this.base.func_174877_v().func_177952_p());
        OMTNetworkingHandler.INSTANCE.sendToServer((IMessage)message);
    }

    public ArrayList<Rectangle> getBlockingAreas() {
        ArrayList<Rectangle> list = new ArrayList<Rectangle>();
        Rectangle rectangleGUI = new Rectangle(0, 0, 0, 0);
        if (PlayerUtil.isPlayerAdmin((EntityPlayer)this.player, (IHasOwner)this.base)) {
            rectangleGUI = new Rectangle((this.field_146294_l - this.field_146999_f) / 2 + 180, (this.field_146295_m - this.field_147000_g) / 2, 80, 120);
        } else if (PlayerUtil.canPlayerChangeSetting((EntityPlayer)this.player, (IHasOwner)this.base)) {
            rectangleGUI = new Rectangle((this.field_146294_l - this.field_146999_f) / 2 + 180, (this.field_146295_m - this.field_147000_g) / 2 + 30, 80, 40);
        }
        list.add(rectangleGUI);
        return list;
    }

    private int getBaseUpperBoundRange() {
        int maxRange = 0;
        ArrayList tileEntities = WorldUtil.getTouchingTileEntities((World)this.base.func_145831_w(), (BlockPos)this.base.func_174877_v());
        for (TileEntity te : tileEntities) {
            if (!(te instanceof TurretHead)) continue;
            maxRange = Math.max(((TurretHead)te).getTurretBaseRange() + TurretHeadUtil.getRangeUpgrades(this.base, (TurretHead)te), maxRange);
        }
        return maxRange;
    }

    public void func_146281_b() {
        OMLibNetworkingHandler.INSTANCE.sendToServer((IMessage)new MessageCloseGUITile((TileEntity)this.base));
        super.func_146281_b();
    }

    @Nullable
    public GuiParameters getGuiParameters() {
        return new GuiParameters((Object)OpenModularTurrets.instance, 1, this.player.func_130014_f_(), this.base.func_174877_v().func_177958_n(), this.base.func_174877_v().func_177956_o(), this.base.func_174877_v().func_177952_p());
    }
}

