/*
 * Decompiled with CFR 0.152.
 */
package com.eternalsoap.icbmopencomputersaddon.drivers;

import com.eternalsoap.icbmopencomputersaddon.drivers.FrequencyEnvironment;
import icbm.classic.api.caps.IMissile;
import icbm.classic.content.blocks.radarstation.TileRadarStation;
import icbm.classic.content.entity.missile.EntityMissile;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class RadarEnvironment
extends FrequencyEnvironment<TileRadarStation>
implements NamedBlock {
    public static final String COMPONENT_NAME = "icbm_radar_station";

    public RadarEnvironment(TileRadarStation radarStation) {
        super(radarStation, COMPONENT_NAME);
    }

    @Callback(doc="function(s:string):boolean -- Method for finding this component when looping through the component list, returns true iff s == \"icbm_radar_station\"")
    public Object[] isICBM(Context context, Arguments arguments) {
        return new Object[]{arguments.checkString(0).equals(COMPONENT_NAME)};
    }

    @Callback(doc="function():number -- Get the Alarm Range of the Radar")
    public Object[] getAlarmRange(Context context, Arguments args) {
        return new Object[]{((TileRadarStation)this.tileEntity).alarmRange};
    }

    @Callback(doc="function(number) -- Set the Alarm Range of the radar. Number must be in range of [1,500]")
    public Object[] setAlarmRange(Context context, Arguments args) {
        int newRange = args.checkInteger(0);
        if (newRange > 500) {
            throw new IllegalArgumentException("Number must be in range of [1,500]");
        }
        ((TileRadarStation)this.tileEntity).alarmRange = newRange;
        return null;
    }

    @Callback(doc="function():number -- Get the Safety Range of the Radar")
    public Object[] getSafetyRange(Context context, Arguments args) {
        return new Object[]{((TileRadarStation)this.tileEntity).safetyRange};
    }

    @Callback(doc="function(number):boolean -- Set the Safety Range of the Radar. Number must be in range of [1,500]")
    public Object[] setSafetyRange(Context context, Arguments args) {
        int newRange = args.checkInteger(0);
        if (newRange > 500) {
            throw new IllegalArgumentException("Number must be in range of [1,500]");
        }
        ((TileRadarStation)this.tileEntity).safetyRange = newRange;
        return new Object[]{true};
    }

    @Callback(doc="function():table -- A list of all incoming missiles")
    public Object[] getIncomingMissiles(Context context, Arguments args) {
        return this.getMissiles(context, args);
    }

    @Callback(doc="function():table -- A list of all incoming missiles")
    public Object[] getMissiles(Context context, Arguments args) {
        try {
            List<IMissile> missiles = this.getMissiles();
            return new Object[]{this.mapToTable(missiles)};
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Callback(doc="function():table -- A list of all incoming missiles")
    public Object[] getMissilesAlt(Context context, Arguments args) {
        BlockPos pos = ((TileRadarStation)this.tileEntity).func_174877_v();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        Object[] objects = ((TileRadarStation)this.tileEntity).func_145831_w().func_72872_a(EntityMissile.class, new AxisAlignedBB((double)(x - 500), (double)(y - 10), (double)(z - 500), (double)(x + 500), (double)(y + 500), (double)(z + 500))).stream().map(missile -> {
            BlockPos position = missile.getPos();
            LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
            value.put("x", position.func_177958_n());
            value.put("y", position.func_177956_o());
            value.put("z", position.func_177952_p());
            String originalUUID = missile.func_110124_au().toString();
            String newUUID = UUID.nameUUIDFromBytes(originalUUID.getBytes()).toString();
            value.put("UUID", newUUID);
            return value;
        }).toArray();
        return new Object[]{objects};
    }

    private List<IMissile> getMissiles() throws NoSuchFieldException, IllegalAccessException {
        Field field = TileRadarStation.class.getDeclaredField("incomingMissiles");
        field.setAccessible(true);
        return (List)field.get(this.tileEntity);
    }

    private Object[] mapToTable(List<IMissile> missiles) {
        Object[] result = new Object[missiles.size()];
        int i = 0;
        for (IMissile missile : missiles) {
            BlockPos position = missile.getPos();
            LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
            value.put("x", position.func_177958_n());
            value.put("y", position.func_177956_o());
            value.put("z", position.func_177952_p());
            String originalUUID = missile.getMissileEntity().func_110124_au().toString();
            String newUUID = UUID.nameUUIDFromBytes(originalUUID.getBytes()).toString();
            value.put("UUID", newUUID);
            result[i] = value;
            ++i;
        }
        return result;
    }

    @Override
    @Callback(doc="function():number -- Get the Frequency the device operates on")
    public Object[] getFrequency(Context context, Arguments args) {
        return super.getFrequency(context, args);
    }

    @Override
    @Callback(doc="function():number -- Set the Frequency the device operates on")
    public Object[] setFrequency(Context context, Arguments args) {
        return super.setFrequency(context, args);
    }

    public String preferredName() {
        return COMPONENT_NAME;
    }

    public int priority() {
        return 1;
    }
}

