/*
 * Decompiled with CFR 0.152.
 */
package com.eternalsoap.icbmopencomputersaddon.drivers;

import com.eternalsoap.icbmopencomputersaddon.util.ManagedTileEntityEnvironment;
import icbm.classic.content.blocks.emptower.EMPMode;
import icbm.classic.content.blocks.emptower.TileEMPTower;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;

public class EMPEnvironment
extends ManagedTileEntityEnvironment<TileEMPTower>
implements NamedBlock {
    public static final String COMPONENT_NAME = "icbm_emp_tower";

    public EMPEnvironment(TileEMPTower tileEntity) {
        super(tileEntity, COMPONENT_NAME);
    }

    @Callback(doc="function(s:string):boolean -- Method for finding this component when looping through the component list, returns true iff s == \"component_emp_tower\"")
    public Object[] isICBM(Context context, Arguments arguments) {
        return new Object[]{arguments.checkString(0).equals(COMPONENT_NAME)};
    }

    @Callback(doc="function():number -- Get the Radius of the EMP Tower")
    public Object[] getRadius(Context context, Arguments args) {
        return new Object[]{((TileEMPTower)this.tileEntity).empRadius};
    }

    @Callback(doc="function(r:number):boolean -- Set the Radius of the EMP Tower.")
    public Object[] setRadius(Context context, Arguments args) {
        ((TileEMPTower)this.tileEntity).empRadius = args.checkInteger(0);
        return null;
    }

    @Callback(doc="function():boolean -- Returns true if the EMP tower is ready to fire an EMP")
    public Object[] isReady(Context context, Arguments args) {
        return new Object[]{((TileEMPTower)this.tileEntity).isReady()};
    }

    @Callback(doc="function():boolean -- Activate the EMP Tower, returns true if it successfully fired, false otherwise ")
    public Object[] launch(Context context, Arguments args) {
        if (((TileEMPTower)this.tileEntity).isReady()) {
            ((TileEMPTower)this.tileEntity).fire();
            return new Object[]{true};
        }
        return new Object[]{false};
    }

    @Callback(doc="function():number -- Gets the mode of the EMP Tower, 0 = Both, 1 = Missile, 2 =  Energy")
    public Object[] getMode(Context context, Arguments args) {
        return new Object[]{((TileEMPTower)this.tileEntity).empMode};
    }

    @Callback(doc="function(mode:number):number -- Set the mode of the EMP Tower, 0 = Both, 1 = Missile, 2 = Energy")
    public Object[] setMode(Context context, Arguments args) {
        switch (args.checkInteger(0)) {
            case 0: {
                ((TileEMPTower)this.tileEntity).empMode = EMPMode.ALL;
                break;
            }
            case 1: {
                ((TileEMPTower)this.tileEntity).empMode = EMPMode.MISSILES_ONLY;
                break;
            }
            case 2: {
                ((TileEMPTower)this.tileEntity).empMode = EMPMode.ELECTRICITY_ONLY;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mode, Mode should be 0, 1 or 2");
            }
        }
        return null;
    }

    public String preferredName() {
        return COMPONENT_NAME;
    }

    public int priority() {
        return 1;
    }
}

