/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.mob;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jeresources.api.drop.LootDrop;
import jeresources.config.Settings;
import jeresources.entry.MobEntry;
import jeresources.util.CollectionHelper;
import jeresources.util.Font;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.ItemStack;

public class MobWrapper
implements IRecipeWrapper,
ITooltipCallback<ItemStack> {
    private final MobEntry mob;
    private float scale;
    private int offsetY;

    public MobWrapper(MobEntry mob) {
        this.mob = mob;
        this.scale = this.getScale(mob.getEntity());
        this.offsetY = this.getOffsetY(mob.getEntity());
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setOutputs(VanillaTypes.ITEM, this.mob.getDropsItemStacks());
    }

    public LootDrop[] getDrops() {
        return this.mob.getDrops();
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String entityString;
        EntityLivingBase entityLivingBase = this.mob.getEntity();
        RenderHelper.scissor(minecraft, 7, 43, 59, 79);
        this.scale = this.getScale(this.mob.getEntity());
        this.offsetY = this.getOffsetY(this.mob.getEntity());
        RenderHelper.renderEntity(37, 105 - this.offsetY, this.scale, 38 - mouseX, 70 - this.offsetY - mouseY, entityLivingBase);
        RenderHelper.stopScissor();
        String mobName = this.mob.getMobName();
        if (Settings.showDevData && (entityString = entityLivingBase.func_70022_Q()) != null) {
            mobName = mobName + " (" + entityString + ")";
        }
        Font.normal.print(mobName, 7, 2);
        Font.normal.print(this.mob.getBiomes().length > 1 ? TranslationHelper.translateToLocal("jer.mob.biome") : TranslationHelper.translateToLocal("jer.mob.spawn") + " " + this.mob.getBiomes()[0], 7, 12);
        Font.normal.print(this.mob.getLightLevel(), 7, 22);
        Font.normal.print(TranslationHelper.translateToLocal("jer.mob.exp") + ": " + this.mob.getExp(), 7, 32);
    }

    @Nullable
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (this.mob.getBiomes().length > 1 && this.isOnBiome(mouseX, mouseY)) {
            return CollectionHelper.create(this.mob.getBiomes());
        }
        return null;
    }

    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
        tooltip.add(this.mob.getDrops()[slotIndex].toString());
        List<String> list = this.getToolTip(ingredient);
        if (list != null) {
            tooltip.addAll(list);
        }
    }

    public EntityLivingBase getMob() {
        return this.mob.getEntity();
    }

    public List<String> getToolTip(ItemStack stack) {
        for (LootDrop item : this.mob.getDrops()) {
            if (stack.func_77969_a(item.item)) {
                return item.getTooltipText();
            }
            if (!item.canBeCooked() || !stack.func_77969_a(item.smeltedItem)) continue;
            return item.getTooltipText(true);
        }
        return null;
    }

    private boolean isOnBiome(int mouseX, int mouseY) {
        return 2 <= mouseX && mouseX < 165 && 12 <= mouseY && mouseY < 22;
    }

    private float getScale(EntityLivingBase entityLivingBase) {
        float width = entityLivingBase.field_70130_N;
        float height = entityLivingBase.field_70131_O;
        if (width <= height) {
            if ((double)height < 0.9) {
                return 50.0f;
            }
            if (height < 1.0f) {
                return 35.0f;
            }
            if ((double)height < 1.8) {
                return 33.0f;
            }
            if (height < 2.0f) {
                return 32.0f;
            }
            if (height < 3.0f) {
                return 24.0f;
            }
            if (height < 4.0f) {
                return 20.0f;
            }
            return 10.0f;
        }
        if (width < 1.0f) {
            return 38.0f;
        }
        if (width < 2.0f) {
            return 27.0f;
        }
        if (width < 3.0f) {
            return 13.0f;
        }
        return 9.0f;
    }

    private int getOffsetY(EntityLivingBase entityLivingBase) {
        int offsetY = 0;
        if (entityLivingBase instanceof EntitySquid) {
            offsetY = 20;
        } else if (entityLivingBase instanceof EntityWitch) {
            offsetY = -10;
        } else if (entityLivingBase instanceof EntityGhast) {
            offsetY = 15;
        } else if (entityLivingBase instanceof EntityWither) {
            offsetY = -15;
        } else if (entityLivingBase instanceof EntityDragon) {
            offsetY = 15;
        } else if (entityLivingBase instanceof EntityEnderman) {
            offsetY = -10;
        } else if (entityLivingBase instanceof EntityGolem) {
            offsetY = -10;
        } else if (entityLivingBase instanceof EntityAnimal) {
            offsetY = -20;
        } else if (entityLivingBase instanceof EntityVillager) {
            offsetY = -15;
        } else if (entityLivingBase instanceof EntityVindicator) {
            offsetY = -15;
        } else if (entityLivingBase instanceof EntityEvoker) {
            offsetY = -10;
        } else if (entityLivingBase instanceof EntityBlaze) {
            offsetY = -10;
        } else if (entityLivingBase instanceof EntityCreeper) {
            offsetY = -15;
        }
        return offsetY;
    }
}

