/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.rendering.grid;

import ivorius.ivtoolkit.rendering.IvRenderHelper;
import ivorius.ivtoolkit.tools.BufferBuilderAccessor;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;

public class GridRenderer {
    public static void renderGrid(int lines, float spacing, float lineLength, float lineWidth) {
        int z;
        int x;
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (x = -lines; x <= lines; ++x) {
            for (z = -lines; z <= lines; ++z) {
                GridRenderer.renderLine((float)x * spacing, -lineLength * 0.5f, (float)z * spacing, EnumFacing.UP, lineLength, lineWidth);
            }
        }
        for (x = -lines; x <= lines; ++x) {
            for (int y = -lines; y <= lines; ++y) {
                GridRenderer.renderLine((float)x * spacing, (float)y * spacing, -lineLength * 0.5f, EnumFacing.SOUTH, lineLength, lineWidth);
            }
        }
        for (int y = -lines; y <= lines; ++y) {
            for (z = -lines; z <= lines; ++z) {
                GridRenderer.renderLine(-lineLength * 0.5f, (float)y * spacing, (float)z * spacing, EnumFacing.EAST, lineLength, lineWidth);
            }
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void renderLine(float x, float y, float z, EnumFacing direction, float length, float size) {
        float xDir = (float)direction.func_82601_c() * length;
        float yDir = (float)direction.func_96559_d() * length;
        float zDir = (float)direction.func_82599_e() * length;
        if (xDir == 0.0f) {
            xDir = size;
        } else {
            x = (float)((double)x + (double)xDir * 0.5);
        }
        if (yDir == 0.0f) {
            yDir = size;
        } else {
            y = (float)((double)y + (double)yDir * 0.5);
        }
        if (zDir == 0.0f) {
            zDir = size;
        } else {
            z = (float)((double)z + (double)zDir * 0.5);
        }
        BufferBuilder renderer = Tessellator.func_178181_a().func_178180_c();
        BufferBuilderAccessor.addTranslation(renderer, x, y, z);
        IvRenderHelper.renderCuboid(renderer, xDir, yDir, zDir, 1.0f);
        BufferBuilderAccessor.addTranslation(renderer, -x, -y, -z);
    }
}

