/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.stitcher.packing2d;

import java.util.ArrayList;
import java.util.List;
import org.embeddedt.vintagefix.stitcher.Rect2D;
import org.embeddedt.vintagefix.stitcher.packing2d.Packer;
import org.embeddedt.vintagefix.stitcher.packing2d.StripLevel;

public class PackerBFDH<T extends Rect2D>
extends Packer<T> {
    private final List<StripLevel> levels = new ArrayList<StripLevel>();

    public PackerBFDH(int stripWidth, List<T> rectangles) {
        super(stripWidth, rectangles);
    }

    @Override
    public List<T> pack() {
        int top = 0;
        this.sortByNonIncreasingHeight(this.rectangles);
        for (Rect2D r : this.rectangles) {
            StripLevel levelWithSmallestResidual = null;
            for (StripLevel level : this.levels) {
                if (!level.canFit(r)) continue;
                if (levelWithSmallestResidual != null && levelWithSmallestResidual.availableWidth() > level.availableWidth()) {
                    levelWithSmallestResidual = level;
                    continue;
                }
                if (levelWithSmallestResidual != null) continue;
                levelWithSmallestResidual = level;
            }
            if (levelWithSmallestResidual == null) {
                StripLevel level = new StripLevel(this.stripWidth, top);
                level.fitRectangle(r);
                this.levels.add(level);
                top += r.height;
                continue;
            }
            StripLevel newLevel = levelWithSmallestResidual.fitRectangle(r);
            if (newLevel == null) continue;
            this.levels.add(this.levels.indexOf(levelWithSmallestResidual) + 1, newLevel);
        }
        return this.rectangles;
    }
}

