/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.mixin.textures;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.StitcherException;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ProgressManager;
import org.embeddedt.vintagefix.annotation.ClientOnlyMixin;
import org.embeddedt.vintagefix.ducks.IDroppingStitcher;
import org.embeddedt.vintagefix.stitcher.TooBigException;
import org.embeddedt.vintagefix.stitcher.TurboStitcher;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Stitcher.class})
@ClientOnlyMixin
public abstract class MixinStitcher
implements IDroppingStitcher {
    @Shadow
    @Final
    private List<Stitcher.Slot> field_94317_b;
    @Shadow
    private int field_94315_d;
    @Shadow
    private int field_94318_c;
    private TurboStitcher masterStitcher;
    private List<Stitcher.Holder> holdersToReadd = new ArrayList<Stitcher.Holder>();

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, require=1)
    private void initTurbo(int maxWidth, int maxHeight, int maxTileDimension, int mipmapLevelStitcher, CallbackInfo ci) {
        this.masterStitcher = new TurboStitcher(maxWidth, maxHeight, true);
    }

    @Redirect(method={"addSprite"}, at=@At(value="INVOKE", target="Ljava/util/Set;add(Ljava/lang/Object;)Z"), require=1)
    private boolean hijackAdd(Set<Stitcher.Holder> instance, Object e) {
        Stitcher.Holder holder = (Stitcher.Holder)e;
        this.masterStitcher.addSprite(holder);
        this.holdersToReadd.add(holder);
        return true;
    }

    @Inject(method={"doStitch"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void doTurboStitch(CallbackInfo ci) {
        ci.cancel();
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Texture stitching", (int)1);
        bar.step("Stitching master atlas");
        try {
            this.masterStitcher.stitch();
            this.field_94318_c = this.masterStitcher.width;
            this.field_94315_d = this.masterStitcher.height;
            this.field_94317_b.clear();
            this.field_94317_b.addAll(this.masterStitcher.getSlots());
        }
        catch (TooBigException ignored) {
            throw new StitcherException(null, "Unable to fit all textures into atlas. Maybe try a lower resolution resourcepack?");
        }
        finally {
            ProgressManager.pop((ProgressManager.ProgressBar)bar);
            this.masterStitcher.reset();
        }
    }

    @Override
    public void dropLargestSprite() {
        this.masterStitcher.dropFirst();
    }

    @Override
    public void retainAllSprites(Set<ResourceLocation> spriteLocations) {
        this.masterStitcher.retainAllSprites(spriteLocations);
    }
}

