/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.mixin.dynamic_resources;

import com.google.common.collect.UnmodifiableIterator;
import it.unimi.dsi.fastutil.ints.Int2BooleanOpenHashMap;
import java.util.EnumMap;
import java.util.Map;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.helpers.ModUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import org.embeddedt.vintagefix.annotation.ClientOnlyMixin;
import org.embeddedt.vintagefix.annotation.LateMixin;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@LateMixin
@ClientOnlyMixin
@Mixin(value={VoxelBlob.class})
public class VoxelBlobMixin {
    @Shadow(remap=false)
    @Final
    private static int array_size;
    @Shadow(remap=false)
    @Final
    private int[] values;
    private static Map<BlockRenderLayer, Int2BooleanOpenHashMap> vfix$layerFilters;

    private static void initLayerFilters() {
        vfix$layerFilters = new EnumMap<BlockRenderLayer, Int2BooleanOpenHashMap>(BlockRenderLayer.class);
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            vfix$layerFilters.put(layer, new Int2BooleanOpenHashMap());
        }
    }

    @Inject(method={"<clinit>"}, at={@At(value="RETURN")})
    private static void setupLayerCache(CallbackInfo ci) {
        VoxelBlobMixin.initLayerFilters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"updateCacheClient"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void clearLayerCache(CallbackInfo ci) {
        ci.cancel();
        Class<VoxelBlob> clazz = VoxelBlob.class;
        synchronized (VoxelBlob.class) {
            if (vfix$layerFilters == null) {
                VoxelBlobMixin.initLayerFilters();
            } else {
                vfix$layerFilters.values().forEach(Int2BooleanOpenHashMap::clear);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite(remap=false)
    public boolean filter(BlockRenderLayer layer) {
        Int2BooleanOpenHashMap layerFilterMap = vfix$layerFilters.get(layer);
        boolean hasValues = false;
        for (int i = 0; i < array_size; ++i) {
            int blockId = this.values[i];
            if (blockId == 0) continue;
            boolean isInLayer = false;
            Int2BooleanOpenHashMap int2BooleanOpenHashMap = layerFilterMap;
            synchronized (int2BooleanOpenHashMap) {
                if (!layerFilterMap.containsKey(blockId)) {
                    IBlockState state;
                    Block block = ModUtil.getStateById((int)blockId).func_177230_c();
                    UnmodifiableIterator unmodifiableIterator = block.func_176194_O().func_177619_a().iterator();
                    while (unmodifiableIterator.hasNext() && ((state = (IBlockState)unmodifiableIterator.next()).func_177230_c() != block || !(isInLayer = block.canRenderInLayer(state, layer)))) {
                    }
                    layerFilterMap.put(blockId, isInLayer);
                } else {
                    isInLayer = layerFilterMap.get(blockId);
                }
            }
            if (isInLayer) {
                hasValues = true;
                continue;
            }
            this.values[i] = 0;
        }
        return hasValues;
    }
}

