/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.mixin.dynamic_resources;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.renderer.StitcherException;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.fml.common.ProgressManager;
import org.embeddedt.vintagefix.VintageFix;
import org.embeddedt.vintagefix.ducks.IDroppingStitcher;
import org.embeddedt.vintagefix.dynamicresources.IWeakTextureMap;
import org.embeddedt.vintagefix.dynamicresources.TextureCollector;
import org.embeddedt.vintagefix.dynamicresources.model.DynamicModelProvider;
import org.embeddedt.vintagefix.dynamicresources.model.ModelLocationInformation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TextureMap.class})
public abstract class MixinTextureMap
implements IWeakTextureMap {
    @Shadow
    @Final
    private Map<String, TextureAtlasSprite> field_110574_e;
    private final Set<String> weakRegisteredSprites = new ObjectOpenHashSet();

    @Shadow
    public abstract TextureAtlasSprite func_174942_a(ResourceLocation var1);

    @Inject(method={"registerSprite"}, at={@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;")})
    private void unregisterWeakSprite(ResourceLocation location, CallbackInfoReturnable<TextureAtlasSprite> cir) {
        String locKey = location.toString();
        if (this.weakRegisteredSprites.contains(locKey)) {
            this.field_110574_e.remove(locKey);
            this.weakRegisteredSprites.remove(locKey);
        }
    }

    @Inject(method={"setTextureEntry"}, at={@At(value="HEAD")}, remap=false)
    private void unregisterWeakSprite2(TextureAtlasSprite sprite, CallbackInfoReturnable<Boolean> ci) {
        String key = sprite.func_94215_i();
        if (this.weakRegisteredSprites.contains(key)) {
            this.field_110574_e.remove(key);
            this.weakRegisteredSprites.remove(key);
        }
    }

    @Inject(method={"loadSprites"}, at={@At(value="HEAD")})
    private void clearWeakSprites(CallbackInfo ci) {
        this.weakRegisteredSprites.clear();
    }

    @Override
    public void registerSpriteWeak(ResourceLocation location) {
        String key = location.toString();
        if (this.weakRegisteredSprites.contains(key) || this.field_110574_e.containsKey(key)) {
            return;
        }
        this.func_174942_a(location);
        this.weakRegisteredSprites.add(key);
    }

    @Inject(method={"loadTextureAtlas"}, at={@At(value="HEAD")})
    private void ignoreWeakTextures(CallbackInfo ci) {
        TextureCollector.weaklyCollectedTextures = new ObjectOpenHashSet(this.weakRegisteredSprites);
        this.weakRegisteredSprites.clear();
    }

    @Redirect(method={"finishLoading"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/Stitcher;doStitch()V"), require=0)
    private void tryStitchAndDropTexture(Stitcher stitcher) {
        if (stitcher instanceof IDroppingStitcher) {
            boolean haveTriedFallbackPass = false;
            while (true) {
                boolean stitchSuccess = false;
                try {
                    if (!haveTriedFallbackPass && Boolean.getBoolean("vintagefix.testFallbackPass")) {
                        throw new StitcherException(null, "forced fallback");
                    }
                    stitcher.func_94305_f();
                    stitchSuccess = true;
                }
                catch (StitcherException stitcherException) {
                    // empty catch block
                }
                if (stitchSuccess) {
                    return;
                }
                if (!haveTriedFallbackPass) {
                    ResourceLocation nextLoad;
                    VintageFix.LOGGER.warn("Failed to fit all textures using greedy approach! Will try slow, scan-all-models fallback now...");
                    HashSet<ResourceLocation> allTextures = new HashSet<ResourceLocation>();
                    DynamicModelProvider.textureCapturer = allTextures;
                    DynamicModelProvider.instance.clearCache();
                    ProgressManager.ProgressBar bar = ProgressManager.push((String)"Fallback texture gathering", (int)1);
                    HashSet<ResourceLocation> loaded = new HashSet<ResourceLocation>();
                    ConcurrentLinkedQueue<ModelResourceLocation> toLoad = new ConcurrentLinkedQueue<ModelResourceLocation>(ModelLocationInformation.allKnownModelLocations);
                    while ((nextLoad = (ResourceLocation)toLoad.poll()) != null) {
                        if (loaded.contains(nextLoad)) continue;
                        loaded.add(nextLoad);
                        try {
                            IModel theModel = DynamicModelProvider.instance.getObject(nextLoad);
                            if (theModel == null) continue;
                            for (ResourceLocation dep : theModel.getDependencies()) {
                                if (loaded.contains(dep)) continue;
                                toLoad.add((ModelResourceLocation)dep);
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                    bar.step("");
                    ProgressManager.pop((ProgressManager.ProgressBar)bar);
                    DynamicModelProvider.textureCapturer = null;
                    haveTriedFallbackPass = true;
                    ((IDroppingStitcher)stitcher).retainAllSprites(allTextures);
                    continue;
                }
                try {
                    ((IDroppingStitcher)stitcher).dropLargestSprite();
                }
                catch (IllegalStateException e) {
                    throw new StitcherException(null, "Could not stitch even with all sprites removed");
                }
            }
        }
        stitcher.func_94305_f();
    }
}

