/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.mixin.bugfix.slow_tps_catchup;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.crash.CrashReport;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ReportedException;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.StartupQuery;
import org.apache.logging.log4j.Logger;
import org.embeddedt.vintagefix.VintageFix;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={MinecraftServer.class}, priority=200)
public abstract class MinecraftServerMixin {
    @Shadow
    protected long field_175591_ab;
    @Shadow
    @Final
    private ServerStatusResponse field_147147_p;
    @Shadow
    private String field_71286_C;
    @Shadow
    private boolean field_71317_u;
    @Shadow
    @Final
    private static Logger field_147145_h;
    @Shadow
    private long field_71299_R;
    @Shadow
    private boolean field_71296_Q;
    @Shadow
    private boolean field_71316_v;

    @Shadow
    public abstract boolean func_71197_b() throws IOException;

    @Shadow
    public static long func_130071_aq() {
        return 0L;
    }

    @Shadow
    public abstract void func_184107_a(ServerStatusResponse var1);

    @Shadow
    public abstract void func_71217_p();

    @Shadow
    public abstract void func_71228_a(CrashReport var1);

    @Shadow
    public abstract CrashReport func_71230_b(CrashReport var1);

    @Shadow
    public abstract File func_71238_n();

    @Shadow
    public abstract void func_71260_j();

    @Shadow
    public abstract void func_71240_o();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Overwrite
    public void run() {
        try {
            if (this.func_71197_b()) {
                long referenceTime;
                VintageFix.LOGGER.info("Using alternate server main loop.");
                FMLCommonHandler.instance().handleServerStarted();
                this.field_175591_ab = referenceTime = MinecraftServerMixin.func_130071_aq();
                this.field_147147_p.func_151315_a((ITextComponent)new TextComponentString(this.field_71286_C));
                this.field_147147_p.func_151321_a(new ServerStatusResponse.Version("1.12.2", 340));
                this.func_184107_a(this.field_147147_p);
                while (true) {
                    long sleepTime;
                    long before;
                    if (!this.field_71317_u) {
                        FMLCommonHandler.instance().handleServerStopping();
                        FMLCommonHandler.instance().expectServerStopped();
                        return;
                    }
                    this.field_175591_ab = before = MinecraftServerMixin.func_130071_aq();
                    this.func_71217_p();
                    long after = MinecraftServerMixin.func_130071_aq();
                    long tickLength = after - before;
                    long runningBehind = before - referenceTime;
                    if (runningBehind > 2000L && after - this.field_71299_R >= 15000L) {
                        field_147145_h.warn("Can't keep up! Did the system time change, or is the server overloaded? Running {}ms behind, skipping {} tick(s)", (Object)runningBehind, (Object)((runningBehind - 2000L - 1L) / 50L + 1L));
                        referenceTime = before - 2000L;
                        runningBehind = 2000L;
                        this.field_71299_R = after;
                    }
                    if (tickLength < 0L || runningBehind < -50L) {
                        field_147145_h.warn("Time ran backwards! Did the system time change?");
                        tickLength = 0L;
                        runningBehind = 0L;
                        referenceTime = before;
                    }
                    if ((sleepTime = 50L - tickLength - runningBehind) > 0L) {
                        Thread.sleep(sleepTime);
                    }
                    referenceTime += 50L;
                    this.field_71296_Q = true;
                }
            }
            FMLCommonHandler.instance().expectServerStopped();
            this.func_71228_a(null);
            return;
        }
        catch (StartupQuery.AbortedException e) {
            FMLCommonHandler.instance().expectServerStopped();
            return;
        }
        catch (Throwable throwable1) {
            field_147145_h.error("Encountered an unexpected exception", throwable1);
            CrashReport crashreport = throwable1 instanceof ReportedException ? this.func_71230_b(((ReportedException)throwable1).func_71575_a()) : this.func_71230_b(new CrashReport("Exception in server tick loop", throwable1));
            File file1 = new File(new File(this.func_71238_n(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (crashreport.func_147149_a(file1)) {
                field_147145_h.error("This crash report has been saved to: {}", (Object)file1.getAbsolutePath());
            } else {
                field_147145_h.error("We were unable to save this crash report to disk.");
            }
            FMLCommonHandler.instance().expectServerStopped();
            this.func_71228_a(crashreport);
            return;
        }
        finally {
            try {
                this.func_71260_j();
            }
            catch (Throwable throwable) {
                field_147145_h.error("Exception stopping the server", throwable);
            }
            finally {
                FMLCommonHandler.instance().handleServerStopped();
                this.field_71316_v = true;
                this.func_71240_o();
            }
        }
    }
}

