/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.dynamicresources.model;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceLinkedOpenHashMap;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;

public class DynamicModelCache<K> {
    private final Reference2ReferenceLinkedOpenHashMap<K, IBakedModel> cache = new Reference2ReferenceLinkedOpenHashMap();
    private final StampedLock lock = new StampedLock();
    private final Function<K, IBakedModel> modelRetriever;
    private final boolean allowNulls;

    public DynamicModelCache(Function<K, IBakedModel> modelRetriever, boolean allowNulls) {
        this.modelRetriever = modelRetriever;
        this.allowNulls = allowNulls;
    }

    public void clear() {
        long stamp = this.lock.writeLock();
        try {
            this.cache.clear();
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needToPopulate(K state) {
        long stamp = this.lock.readLock();
        try {
            boolean bl = !this.cache.containsKey(state);
            return bl;
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBakedModel getModelFromCache(K state) {
        long stamp = this.lock.readLock();
        try {
            IBakedModel iBakedModel = (IBakedModel)this.cache.get(state);
            return iBakedModel;
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBakedModel cacheModel(K state) {
        IBakedModel model = this.modelRetriever.apply(state);
        long stamp = this.lock.writeLock();
        try {
            this.cache.putAndMoveToFirst(state, (Object)model);
            if (this.cache.size() >= 1000) {
                this.cache.removeLast();
            }
        }
        finally {
            this.lock.unlock(stamp);
        }
        return model;
    }

    public IBakedModel get(K key) {
        IBakedModel model = this.getModelFromCache(key);
        if (model == null && (!this.allowNulls || this.needToPopulate(key))) {
            model = this.cacheModel(key);
        }
        return model;
    }
}

