/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.lang.reflect.Field;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.collect.Table;

public final class ReflectionUtil {
    private static final Table<Class, Class, Optional<Field>> CACHE = Table.hashBasedTable();

    private ReflectionUtil() {
    }

    public static boolean isClassLoaded(String className) {
        try {
            Class.forName(className, false, ReflectionUtil.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Nullable
    public static <T> T getFieldWithClass(Object object, Class<T> fieldClass) {
        Field field = ReflectionUtil.getField(object, fieldClass);
        if (field != null) {
            try {
                Object fieldValue = field.get(object);
                if (fieldClass.isInstance(fieldValue)) {
                    return fieldClass.cast(fieldValue);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private static Field getField(Object object, Class<?> fieldClass) {
        Class<?> objectClass = object.getClass();
        Optional<Field> cachedField = CACHE.get(fieldClass, objectClass);
        if (cachedField != null) {
            return cachedField.orElse(null);
        }
        try {
            Field[] fields;
            for (Field field : fields = objectClass.getDeclaredFields()) {
                if (!fieldClass.isAssignableFrom(field.getType())) continue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                CACHE.put(fieldClass, objectClass, Optional.of(field));
                return field;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        CACHE.put(fieldClass, objectClass, Optional.empty());
        return null;
    }
}

