/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.search;

import java.io.PrintWriter;
import java.util.Set;
import javax.annotation.Nullable;
import mezz.jei.search.Edge;
import mezz.jei.search.ISearchStorage;
import mezz.jei.search.Node;
import mezz.jei.util.Substring;
import org.apache.commons.lang3.tuple.Pair;

public class GeneralizedSuffixTree<T>
implements ISearchStorage<T> {
    private final Node.Root<T> root = new Node.Root();
    private Node<T> activeLeaf = this.root;

    @Override
    public void getSearchResults(String word, Set<T> results) {
        Node<T> tmpNode = GeneralizedSuffixTree.searchNode(this.root, word);
        if (tmpNode == null) {
            return;
        }
        tmpNode.getData(results);
    }

    @Override
    public void getAllElements(Set<T> results) {
        this.root.getData(results);
    }

    @Nullable
    private static <T> Node<T> searchNode(Node<T> root, String word) {
        Node<T> currentNode = root;
        Substring wordSubstring = new Substring(word);
        while (!wordSubstring.isEmpty()) {
            Edge<T> currentEdge = currentNode.getEdge(wordSubstring);
            if (currentEdge == null) {
                return null;
            }
            int lenToMatch = Math.min(wordSubstring.length(), currentEdge.length());
            if (!currentEdge.regionMatches(wordSubstring, lenToMatch)) {
                return null;
            }
            if (lenToMatch == wordSubstring.length()) {
                return currentEdge.getDest();
            }
            currentNode = currentEdge.getDest();
            wordSubstring = wordSubstring.substring(lenToMatch);
        }
        return null;
    }

    @Override
    public void put(String key, T value) {
        this.activeLeaf = this.root;
        Node s = this.root;
        Substring text = new Substring(key, 0, 0);
        for (int i = 0; i < key.length(); ++i) {
            Substring rest = new Substring(key, i);
            Pair<Node<T>, Substring> active = this.update(s, text, key.charAt(i), rest, value);
            s = (Node)active.getLeft();
            text = (Substring)active.getRight();
        }
        if (null == this.activeLeaf.getSuffix() && this.activeLeaf != this.root && this.activeLeaf != s) {
            this.activeLeaf.setSuffix(s);
        }
    }

    private static <T> Pair<Boolean, Node<T>> testAndSplit(Node<T> startNode, Substring searchString, char t, Substring remainder, T value) {
        assert (!remainder.isEmpty());
        assert (remainder.charAt(0) == t);
        Pair<Node<T>, Substring> canonizeResult = GeneralizedSuffixTree.canonize(startNode, searchString);
        startNode = (Node)canonizeResult.getLeft();
        searchString = (Substring)canonizeResult.getRight();
        if (!searchString.isEmpty()) {
            Edge g = startNode.getEdge(searchString);
            assert (g != null);
            if (g.length() > searchString.length() && g.charAt(searchString.length()) == t) {
                return Pair.of((Object)true, (Object)startNode);
            }
            Node newNode = GeneralizedSuffixTree.splitNode(startNode, g, searchString);
            return Pair.of((Object)false, newNode);
        }
        Edge e = startNode.getEdge(remainder);
        if (e == null) {
            return Pair.of((Object)false, (Object)startNode);
        }
        if (e.startsWith(remainder)) {
            if (e.length() == remainder.length()) {
                Node<T> dest = e.getDest();
                dest.addRef(value);
                return Pair.of((Object)true, (Object)startNode);
            }
            Node<T> newNode = GeneralizedSuffixTree.splitNode(startNode, e, remainder);
            newNode.addRef(value);
            return Pair.of((Object)false, (Object)startNode);
        }
        return Pair.of((Object)true, (Object)startNode);
    }

    private static <T> Node<T> splitNode(Node<T> s, Edge<T> e, Substring splitFirstPart) {
        assert (e == s.getEdge(splitFirstPart));
        assert (e.startsWith(splitFirstPart));
        assert (e.length() > splitFirstPart.length());
        Substring splitSecondPart = e.substring(splitFirstPart.length());
        Node<T> r = new Node<T>();
        s.addEdge(new Edge(splitFirstPart, r));
        r.addEdge(new Edge<T>(splitSecondPart, e.getDest()));
        return r;
    }

    private static <T> Pair<Node<T>, Substring> canonize(Node<T> s, Substring input) {
        Edge<T> nextEdge;
        Node<T> currentNode = s;
        Substring remainder = input;
        while (!remainder.isEmpty() && (nextEdge = currentNode.getEdge(remainder)) != null && nextEdge.isPrefix(remainder)) {
            currentNode = nextEdge.getDest();
            remainder = remainder.substring(nextEdge.length());
        }
        return Pair.of(currentNode, (Object)remainder);
    }

    private Pair<Node<T>, Substring> update(Node<T> s, Substring stringPart, char newChar, Substring rest, T value) {
        assert (!rest.isEmpty());
        assert (rest.charAt(0) == newChar);
        Substring k = stringPart.append(newChar);
        Node oldRoot = this.root;
        Pair<Boolean, Node<T>> ret = GeneralizedSuffixTree.testAndSplit(s, stringPart, newChar, rest, value);
        Node r = (Node)ret.getRight();
        boolean endpoint = (Boolean)ret.getLeft();
        while (!endpoint) {
            Node<T> leaf;
            Edge tempEdge = r.getEdge(newChar);
            if (tempEdge != null) {
                leaf = tempEdge.getDest();
            } else {
                leaf = new Node();
                leaf.addRef(value);
                r.addEdge(new Edge(rest, leaf));
            }
            if (this.activeLeaf != this.root) {
                this.activeLeaf.setSuffix(leaf);
            }
            this.activeLeaf = leaf;
            if (oldRoot != this.root) {
                oldRoot.setSuffix(r);
            }
            oldRoot = r;
            if (null == s.getSuffix()) {
                assert (this.root == s);
                k = k.substring(1);
            } else {
                Pair<Node<T>, Substring> canonized = GeneralizedSuffixTree.canonize(s.getSuffix(), GeneralizedSuffixTree.safeCutLastChar(k));
                char nextChar = k.charAt(k.length() - 1);
                s = (Node)canonized.getLeft();
                k = ((Substring)canonized.getRight()).append(nextChar);
            }
            ret = GeneralizedSuffixTree.testAndSplit(s, GeneralizedSuffixTree.safeCutLastChar(k), newChar, rest, value);
            endpoint = (Boolean)ret.getLeft();
            r = (Node)ret.getRight();
        }
        if (oldRoot != this.root) {
            oldRoot.setSuffix(r);
        }
        return GeneralizedSuffixTree.canonize(s, k);
    }

    private static Substring safeCutLastChar(Substring subString) {
        if (subString.length() == 0) {
            return subString;
        }
        return subString.shorten(1);
    }

    @Override
    public String statistics() {
        return "GeneralizedSuffixTree:\nNode size stats: \n" + this.root.nodeSizeStats() + "\nNode edge stats: \n" + this.root.nodeEdgeStats();
    }

    @Override
    public void printTree(PrintWriter out, boolean includeSuffixLinks) {
        this.root.printTree(out, includeSuffixLinks);
    }
}

