/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweakercore.module;

import me.superckl.biometweakercore.BiomeTweakerCore;
import me.superckl.biometweakercore.module.IClassTransformerModule;
import me.superckl.biometweakercore.util.ASMHelper;
import me.superckl.biometweakercore.util.ObfNameHelper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ModuleWorldProvider
implements IClassTransformerModule {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (!BiomeTweakerCore.config.isFogColor()) {
            return bytes;
        }
        ClassNode cNode = ASMHelper.readClassFromBytes(bytes);
        BiomeTweakerCore.logger.info("Attempting to patch class " + transformedName + "...");
        MethodNode mNode = ASMHelper.findMethodNodeOfClass(cNode, ObfNameHelper.Methods.GETFOGCOLOR.getName(), ObfNameHelper.Methods.GETFOGCOLOR.getDescriptor());
        if (mNode == null) {
            BiomeTweakerCore.logger.error("Unable to find getFogColor method! Tweak will not be applied.");
            return bytes;
        }
        AbstractInsnNode aNode = ASMHelper.find(ASMHelper.findFirstInstructionWithOpcode(mNode, 56).getNext(), (AbstractInsnNode)new VarInsnNode(56, 3));
        if (aNode == null) {
            BiomeTweakerCore.logger.error("Unable to find insertion site in getFogColor method! Tweak will not be applied.");
            return bytes;
        }
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)ObfNameHelper.Methods.GETBIOME.toInsnNode(184));
        list.add((AbstractInsnNode)ObfNameHelper.Fields.FOGCOLOR.toInsnNode(180));
        list.add((AbstractInsnNode)new InsnNode(2));
        LabelNode label = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(159, label));
        list.add((AbstractInsnNode)ObfNameHelper.Methods.GETBIOME.toInsnNode(184));
        list.add((AbstractInsnNode)ObfNameHelper.Fields.FOGCOLOR.toInsnNode(180));
        list.add((AbstractInsnNode)new VarInsnNode(23, 3));
        list.add((AbstractInsnNode)ObfNameHelper.Methods.CALCFOGCOLOR.toInsnNode(184));
        list.add((AbstractInsnNode)new InsnNode(176));
        list.add((AbstractInsnNode)label);
        list.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        mNode.instructions.insert(aNode, list);
        BiomeTweakerCore.logger.info("Sucessfully patched " + transformedName + "!");
        return ASMHelper.writeClassToBytes(cNode, 2);
    }

    @Override
    public String[] getClassesToTransform() {
        return new String[]{ObfNameHelper.Classes.WORLDPROVIDER.getName()};
    }

    @Override
    public String getModuleName() {
        return "moduleTransformWorldProvider";
    }

    @Override
    public boolean isRequired() {
        return false;
    }
}

