/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweakercore.module;

import me.superckl.biometweakercore.BiomeTweakerCore;
import me.superckl.biometweakercore.module.IClassTransformerModule;
import me.superckl.biometweakercore.util.ASMHelper;
import me.superckl.biometweakercore.util.ObfNameHelper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ModuleWorld
implements IClassTransformerModule {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (!BiomeTweakerCore.config.isInitialSnow()) {
            return bytes;
        }
        ClassNode cNode = ASMHelper.readClassFromBytes(bytes);
        BiomeTweakerCore.logger.info("Attempting to patch class " + transformedName + "...");
        MethodNode mNode = ASMHelper.findMethodNodeOfClass(cNode, ObfNameHelper.Methods.CANSNOWATBODY.getName(), ObfNameHelper.Methods.CANSNOWATBODY.getDescriptor());
        if (mNode == null) {
            BiomeTweakerCore.logger.error("Unable to find canSnowAtBody method! Tweak will not be applied.");
            return bytes;
        }
        AbstractInsnNode aNode = ASMHelper.findFirstInstructionWithOpcode(mNode, 58);
        if (aNode == null) {
            BiomeTweakerCore.logger.error("Unable to find insertion site in canSnowAtBody method! Tweak will not be applied.");
            return bytes;
        }
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 3));
        list.add((AbstractInsnNode)ObfNameHelper.Fields.GENINITIALSNOW.toInsnNode(180));
        LabelNode label = new LabelNode();
        list.add((AbstractInsnNode)new JumpInsnNode(198, label));
        list.add((AbstractInsnNode)new VarInsnNode(25, 3));
        list.add((AbstractInsnNode)ObfNameHelper.Fields.GENINITIALSNOW.toInsnNode(180));
        list.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Boolean", "booleanValue", "()Z", false));
        list.add((AbstractInsnNode)new InsnNode(172));
        list.add((AbstractInsnNode)label);
        list.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        mNode.instructions.insert(aNode, list);
        BiomeTweakerCore.logger.info("Sucessfully patched " + transformedName + "!");
        return ASMHelper.writeClassToBytes(cNode, 2);
    }

    @Override
    public String[] getClassesToTransform() {
        return new String[]{ObfNameHelper.Classes.WORLD.getName()};
    }

    @Override
    public String getModuleName() {
        return "moduleTransformWorld";
    }

    @Override
    public boolean isRequired() {
        return false;
    }
}

