/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweakercore.module;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.superckl.biometweakercore.BiomeTweakerCore;
import me.superckl.biometweakercore.module.IClassTransformerModule;
import me.superckl.biometweakercore.util.ASMHelper;
import me.superckl.biometweakercore.util.ObfNameHelper;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ModuleBiomeSubclass
implements IClassTransformerModule {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        if (ASMHelper.doesClassExtend(reader, FMLDeobfuscatingRemapper.INSTANCE.unmap(ObfNameHelper.Classes.BIOME.getInternalName()))) {
            ClassNode cNode = new ClassNode();
            reader.accept((ClassVisitor)cNode, 0);
            for (MethodNode mNode : cNode.methods) {
                AbstractInsnNode node;
                InsnList list;
                AbstractInsnNode aNode;
                if (BiomeTweakerCore.config.isGrassColor() && ObfNameHelper.Methods.GETBIOMEGRASSCOLOR.matches(mNode)) {
                    Object methNode;
                    boolean shouldCont = false;
                    aNode = mNode.instructions.get(mNode.instructions.size() - 2);
                    if (aNode instanceof MethodInsnNode && ObfNameHelper.Methods.GETMODDEDBIOMEGRASSCOLOR.matches((MethodInsnNode)(methNode = (MethodInsnNode)aNode))) {
                        shouldCont = true;
                        break;
                    }
                    if (shouldCont) continue;
                    BiomeTweakerCore.logger.debug("Found Biome subclass " + transformedName + " with overriden grass color method and no event call. Attempting to force modded color event call...");
                    methNode = this.findReturnNodes(mNode.instructions).iterator();
                    while (methNode.hasNext()) {
                        AbstractInsnNode aINode = (AbstractInsnNode)methNode.next();
                        list = new InsnList();
                        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        list.add((AbstractInsnNode)ObfNameHelper.Methods.CALLGRASSCOLOREVENT.toInsnNode(184));
                        mNode.instructions.insertBefore(aINode, list);
                    }
                    continue;
                }
                if (BiomeTweakerCore.config.isFoliageColor() && ObfNameHelper.Methods.GETBIOMEFOLIAGECOLOR.matches(mNode)) {
                    MethodInsnNode methNode;
                    boolean shouldCont = false;
                    aNode = mNode.instructions.get(mNode.instructions.size() - 2);
                    if (aNode instanceof MethodInsnNode && ObfNameHelper.Methods.GETMODDEDBIOMEFOLIAGECOLOR.matches(methNode = (MethodInsnNode)aNode)) {
                        shouldCont = true;
                        break;
                    }
                    if (shouldCont) continue;
                    BiomeTweakerCore.logger.debug("Found Biome subclass " + transformedName + " with overriden foliage color method and no event call. Attempting to force modded color event call...");
                    for (AbstractInsnNode aINode : this.findReturnNodes(mNode.instructions)) {
                        list = new InsnList();
                        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        list.add((AbstractInsnNode)ObfNameHelper.Methods.CALLFOLIAGECOLOREVENT.toInsnNode(184));
                        mNode.instructions.insertBefore(aINode, list);
                    }
                    continue;
                }
                if (BiomeTweakerCore.config.isWaterColor() && ObfNameHelper.Methods.GETWATERCOLORMULTIPLIER.matches(mNode)) {
                    BiomeTweakerCore.logger.debug("Found Biome subclass " + transformedName + " with overriden water color method. Attempting to force modded color event call...");
                    for (AbstractInsnNode aINode : this.findReturnNodes(mNode.instructions)) {
                        InsnList list2 = new InsnList();
                        list2.add((AbstractInsnNode)new VarInsnNode(25, 0));
                        list2.add((AbstractInsnNode)ObfNameHelper.Methods.CALLWATERCOLOREVENT.toInsnNode(184));
                        mNode.instructions.insertBefore(aINode, list2);
                    }
                    continue;
                }
                if (!BiomeTweakerCore.config.isRemoveLateAssignments() || !ObfNameHelper.Methods.GENTERRAINBLOCKS.matches(mNode)) continue;
                AbstractInsnNode nextNode = node = ASMHelper.findFirstInstruction(mNode);
                int removed = 0;
                do {
                    try {
                        AbstractInsnNode prevNode;
                        FieldInsnNode fNode;
                        nextNode = node.getNext();
                        if (!(node instanceof FieldInsnNode) || !ObfNameHelper.Fields.TOPBLOCK.matches(fNode = (FieldInsnNode)node, true) && !ObfNameHelper.Fields.FILLERBLOCK.matches(fNode, true) || (prevNode = ASMHelper.findPreviousInstruction((AbstractInsnNode)fNode)) == null || !(prevNode instanceof MethodInsnNode) || prevNode.getOpcode() != 182 && prevNode.getOpcode() != 185) continue;
                        MethodInsnNode prevMNode = (MethodInsnNode)prevNode;
                        if (!ObfNameHelper.Methods.GETDEFAULTSTATE.matches(prevMNode, true)) {
                            prevNode = ASMHelper.findPreviousInstruction(ASMHelper.findPreviousInstruction(ASMHelper.findPreviousInstruction((AbstractInsnNode)prevMNode)));
                            if (prevNode == null || !(prevNode instanceof MethodInsnNode) || prevNode.getOpcode() != 182) continue;
                            prevMNode = (MethodInsnNode)prevNode;
                        }
                        if (!ObfNameHelper.Methods.GETDEFAULTSTATE.matches(prevMNode, true) || (prevNode = ASMHelper.findPreviousInstruction((AbstractInsnNode)prevMNode)) == null || !(prevNode instanceof FieldInsnNode) || prevNode.getOpcode() != 178) continue;
                        FieldInsnNode prevFNode = (FieldInsnNode)prevNode;
                        if (!prevFNode.desc.equals(ASMHelper.toDescriptor(ObfNameHelper.Classes.BLOCK.getInternalName())) && !ASMHelper.doesClassExtend(ASMHelper.getClassReaderForClassName(Type.getType((String)prevFNode.desc).getClassName()), ObfNameHelper.Classes.BLOCK.getInternalName()) || (prevNode = ASMHelper.findPreviousInstruction((AbstractInsnNode)prevFNode)) == null || !(prevNode instanceof VarInsnNode) || prevNode.getOpcode() != 25 || ((VarInsnNode)prevNode).var != 0) continue;
                        ASMHelper.removeFromInsnListUntil(mNode.instructions, prevNode, nextNode);
                        ++removed;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } while ((node = ASMHelper.findNextInstructionWithOpcode(nextNode, 181)) != null);
                if (removed <= 0) continue;
                if (name.startsWith("net.minecraft.world.biome.")) {
                    BiomeTweakerCore.logger.warn("Found vanilla Biome subclass " + transformedName + " that was setting topBlock" + " or fillerBlock in genTerrainBlocks!" + removed + " items were removed. If this is not a vanilla biome," + " please let me (superckl) know.");
                } else {
                    BiomeTweakerCore.logger.warn("Found Biome subclass " + transformedName + " that was setting topBlock or fillerBlock" + " in genTerrainBlocks! This is bad practice and breaks functionality in BiomeTweaker! " + removed + " items" + " were removed. If this is a vanilla biome, please let me (superckl) know.");
                }
                BiomeTweakerCore.logger.info("If you feel the removal of this is causing issues, add this class to the ASM blacklist in the config and let me know.");
            }
            return ASMHelper.writeClassToBytes(cNode);
        }
        return basicClass;
    }

    @Override
    public String[] getClassesToTransform() {
        return new String[]{"*"};
    }

    @Override
    public String getModuleName() {
        return "moduleTransformBiomeSubclass";
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    private List<AbstractInsnNode> findReturnNodes(InsnList instructions) {
        ArrayList<AbstractInsnNode> list = new ArrayList<AbstractInsnNode>();
        for (int i = instructions.size() - 1; i >= 0; --i) {
            if (instructions.get(i).getOpcode() != 172) continue;
            list.add(instructions.get(i));
        }
        return list;
    }
}

