/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweakercore;

import com.google.common.collect.Sets;
import java.util.Set;
import me.superckl.biometweakercore.BiomeTweakerCore;
import me.superckl.biometweakercore.module.IClassTransformerModule;
import me.superckl.biometweakercore.module.ModuleBiome;
import me.superckl.biometweakercore.module.ModuleBiomeSubclass;
import me.superckl.biometweakercore.module.ModuleWorld;
import me.superckl.biometweakercore.module.ModuleWorldProvider;
import me.superckl.biometweakercore.util.CollectionHelper;
import net.minecraft.launchwrapper.IClassTransformer;

public class BiomeTweakerASMTransformer
implements IClassTransformer {
    private final Set<IClassTransformerModule> modules = Sets.newIdentityHashSet();

    public BiomeTweakerASMTransformer() {
        this.registerModule(new ModuleBiome());
        this.registerModule(new ModuleBiomeSubclass());
        this.registerModule(new ModuleWorldProvider());
        this.registerModule(new ModuleWorld());
    }

    public void registerModule(IClassTransformerModule module) {
        this.modules.add(module);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (BiomeTweakerCore.config == null || basicClass == null || CollectionHelper.find(transformedName, BiomeTweakerCore.config.getAsmBlacklist()) != -1) {
            return basicClass;
        }
        for (IClassTransformerModule module : this.modules) {
            for (String clazz : module.getClassesToTransform()) {
                if (!clazz.equals("*") && !clazz.equals(transformedName)) continue;
                try {
                    byte[] newBytes = module.transform(name, transformedName, basicClass);
                    basicClass = newBytes;
                }
                catch (Exception e) {
                    BiomeTweakerCore.logger.error("Caught an exception from module " + module.getModuleName());
                    e.printStackTrace();
                }
            }
        }
        return basicClass;
    }
}

