/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math.geo;

import com.creativemd.creativecore.common.utils.math.VectorUtils;
import com.creativemd.creativecore.common.utils.math.vec.IVecInt;
import com.creativemd.creativecore.common.utils.math.vec.VectorFan;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import net.minecraft.util.EnumFacing;

public class Ray2d {
    public double originOne;
    public double originTwo;
    public double directionOne;
    public double directionTwo;
    public EnumFacing.Axis one;
    public EnumFacing.Axis two;

    public Ray2d(EnumFacing.Axis one, EnumFacing.Axis two, Vector3d origin, double directionOne, double directionTwo) {
        this.one = one;
        this.two = two;
        this.originOne = VectorUtils.get(one, (Tuple3d)origin);
        this.originTwo = VectorUtils.get(two, (Tuple3d)origin);
        this.directionOne = directionOne;
        this.directionTwo = directionTwo;
    }

    public Ray2d(EnumFacing.Axis one, EnumFacing.Axis two, IVecInt origin, double directionOne, double directionTwo) {
        this.one = one;
        this.two = two;
        this.originOne = origin.get(one);
        this.originTwo = origin.get(two);
        this.directionOne = directionOne;
        this.directionTwo = directionTwo;
    }

    public Ray2d(EnumFacing.Axis one, EnumFacing.Axis two, double startOne, double startTwo, double endOne, double endTwo) {
        this.set(one, two, startOne, startTwo, endOne, endTwo);
    }

    public double getOrigin(EnumFacing.Axis axis) {
        if (this.one == axis) {
            return this.originOne;
        }
        return this.originTwo;
    }

    public double getDirection(EnumFacing.Axis axis) {
        if (this.one == axis) {
            return this.directionOne;
        }
        return this.directionTwo;
    }

    public EnumFacing.Axis getOther(EnumFacing.Axis axis) {
        if (this.one == axis) {
            return this.two;
        }
        return this.one;
    }

    public void set(EnumFacing.Axis one, EnumFacing.Axis two, double startOne, double startTwo, double endOne, double endTwo) {
        this.one = one;
        this.two = two;
        this.originOne = startOne;
        this.originTwo = startTwo;
        this.directionOne = endOne - startOne;
        this.directionTwo = endTwo - startTwo;
    }

    public void set(EnumFacing.Axis one, EnumFacing.Axis two, Vector3f first, Vector3f second) {
        this.one = one;
        this.two = two;
        this.originOne = VectorUtils.get(one, (Tuple3f)first);
        this.originTwo = VectorUtils.get(two, (Tuple3f)first);
        this.directionOne = (double)VectorUtils.get(one, (Tuple3f)second) - this.originOne;
        this.directionTwo = (double)VectorUtils.get(two, (Tuple3f)second) - this.originTwo;
    }

    public double getT(EnumFacing.Axis axis, double value) {
        return (value - this.getOrigin(axis)) / this.getDirection(axis);
    }

    public double get(EnumFacing.Axis axis, double value) {
        EnumFacing.Axis other = this.getOther(axis);
        return this.getOrigin(other) + this.getDirection(other) * (value - this.getOrigin(axis)) / this.getDirection(axis);
    }

    public Vector2d get(double t) {
        return new Vector2d(this.originOne + this.directionOne * t, this.originTwo + this.directionTwo * t);
    }

    public Vector2f getFloat(double t) {
        return new Vector2f((float)(this.originOne + this.directionOne * t), (float)(this.originTwo + this.directionTwo * t));
    }

    public Double getWithLimits(EnumFacing.Axis axis, double value) {
        return this.getWithLimits(axis, value, 0.0, 1.0);
    }

    public Double getWithLimits(EnumFacing.Axis axis, double value, double min, double max) {
        EnumFacing.Axis other = this.getOther(axis);
        double position = (value - this.getOrigin(axis)) / this.getDirection(axis);
        if (position < min || position > max) {
            return null;
        }
        return this.getOrigin(other) + this.getDirection(other) * position;
    }

    public boolean isCoordinateOnLine(int one, int two) {
        return this.get(this.one, one) == (double)two;
    }

    public boolean isCoordinateOnLine(double one, double two) {
        if (this.directionOne == 0.0) {
            return VectorUtils.equals(this.originOne, one);
        }
        if (this.directionTwo == 0.0) {
            return VectorUtils.equals(this.originTwo, two);
        }
        return VectorUtils.equals(this.get(this.one, one), two);
    }

    public boolean isCoordinateToTheRight(int one, int two) {
        double tempTwo = (double)two - this.originTwo;
        double tempOne = (double)one - this.originOne;
        return this.directionOne * tempTwo - this.directionTwo * tempOne < 0.0;
    }

    public Boolean isCoordinateToTheRight(double one, double two) {
        double tempTwo = two - this.originTwo;
        double tempOne = one - this.originOne;
        double result = this.directionOne * tempTwo - this.directionTwo * tempOne;
        if (result > (double)-1.0E-4f && result < (double)1.0E-4f) {
            return null;
        }
        return result < 0.0;
    }

    public Vector3f intersect(Vector3f start, Vector3f end, float thirdValue) {
        float lineOriginOne = VectorUtils.get(this.one, (Tuple3f)start);
        float lineOriginTwo = VectorUtils.get(this.two, (Tuple3f)start);
        float lineDirectionOne = VectorUtils.get(this.one, (Tuple3f)end) - VectorUtils.get(this.one, (Tuple3f)start);
        float lineDirectionTwo = VectorUtils.get(this.two, (Tuple3f)end) - VectorUtils.get(this.two, (Tuple3f)start);
        if (VectorUtils.isZero(this.directionOne * (double)lineDirectionTwo - this.directionTwo * (double)lineDirectionOne)) {
            return null;
        }
        Vector3f vec = new Vector3f(thirdValue, thirdValue, thirdValue);
        double t = (((double)lineOriginTwo - this.originTwo) * (double)lineDirectionOne + this.originOne * (double)lineDirectionTwo - (double)(lineOriginOne * lineDirectionTwo)) / ((double)lineDirectionOne * this.directionTwo - this.directionOne * (double)lineDirectionTwo);
        VectorUtils.set((Tuple3f)vec, (float)(this.originOne + t * this.directionOne), this.one);
        VectorUtils.set((Tuple3f)vec, (float)(this.originTwo + t * this.directionTwo), this.two);
        return vec;
    }

    public double intersectWhen(Ray2d line) throws VectorFan.ParallelException {
        if (VectorUtils.isZero(this.directionOne * line.directionTwo - this.directionTwo * line.directionOne)) {
            if (this.isCoordinateOnLine(line.originOne, line.originTwo)) {
                throw new VectorFan.ParallelException();
            }
            return -1.0;
        }
        return ((line.originTwo - this.originTwo) * line.directionOne + this.originOne * line.directionTwo - line.originOne * line.directionTwo) / (line.directionOne * this.directionTwo - this.directionOne * line.directionTwo);
    }

    public Vector3d intersect(Ray2d line, int thirdValue) {
        if (VectorUtils.isZero(this.directionOne * line.directionTwo - this.directionTwo * line.directionOne)) {
            return null;
        }
        Vector3d vec = new Vector3d((double)thirdValue, (double)thirdValue, (double)thirdValue);
        double t = ((line.originTwo - this.originTwo) * line.directionOne + this.originOne * line.directionTwo - line.originOne * line.directionTwo) / (line.directionOne * this.directionTwo - this.directionOne * line.directionTwo);
        VectorUtils.set((Tuple3d)vec, this.originOne + t * this.directionOne, this.one);
        VectorUtils.set((Tuple3d)vec, this.originTwo + t * this.directionTwo, this.two);
        return vec;
    }

    public String toString() {
        return this.one + "," + this.two + ",[" + this.originOne + "," + this.originTwo + "],[" + this.directionOne + "," + this.directionTwo + "]";
    }
}

