/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.packet.gui;

import com.creativemd.creativecore.common.gui.container.SubContainer;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.mc.ContainerSub;
import com.creativemd.creativecore.common.gui.mc.GuiContainerSub;
import com.creativemd.creativecore.common.gui.opener.CustomGuiHandler;
import com.creativemd.creativecore.common.gui.opener.GuiHandler;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OpenGuiPacket
extends CreativeCorePacket {
    public String name;
    public NBTTagCompound nbt;

    public OpenGuiPacket() {
    }

    public OpenGuiPacket(String name, NBTTagCompound nbt) {
        this.name = name;
        this.nbt = nbt;
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        OpenGuiPacket.writeString(buf, this.name);
        OpenGuiPacket.writeNBT(buf, this.nbt);
    }

    @Override
    public void readBytes(ByteBuf buf) {
        this.name = OpenGuiPacket.readString(buf);
        this.nbt = OpenGuiPacket.readNBT(buf);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void executeClient(EntityPlayer player) {
        if (!Minecraft.func_71410_x().func_71356_B() && Minecraft.func_71410_x().func_147104_D() == null) {
            return;
        }
        CustomGuiHandler handler = GuiHandler.getHandler(this.name);
        if (handler != null) {
            SubGui gui = handler.getGui(player, this.nbt);
            SubContainer container = handler.getContainer(player, this.nbt);
            if (gui != null && container != null) {
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiContainerSub(player, gui, container));
            }
        }
    }

    @Override
    public void executeServer(EntityPlayer player) {
        SubContainer container;
        PacketHandler.sendPacketToPlayer(this, (EntityPlayerMP)player);
        CustomGuiHandler handler = GuiHandler.getHandler(this.name);
        if (handler != null && (container = handler.getContainer(player, this.nbt)) != null) {
            OpenGuiPacket.openContainerOnServer((EntityPlayerMP)player, new ContainerSub(player, container));
        }
    }
}

