/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls.gui.text;

import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.controls.gui.text.TextareaRange;

public interface IWordMatcher {
    public static final IWordMatcher DEFAULT_MATCHER = new IWordMatcher(){

        @Override
        public int findNextWordStartBoundary(String text, int from) {
            IWordMatcher.checkBounds(text, from);
            return -1;
        }

        @Override
        public int findNextWordEndBoundary(String text, int from) {
            IWordMatcher.checkBounds(text, from);
            return text == null || from == text.length() ? -1 : text.length();
        }

        @Override
        public int findPreviousWordStartBoundary(String text, int from) {
            IWordMatcher.checkBounds(text, from);
            return text == null || from == 0 ? -1 : 0;
        }

        @Override
        public int findPreviousWordEndBoundary(String text, int from) {
            IWordMatcher.checkBounds(text, from);
            return -1;
        }
    };

    default public int findNextWordBoundary(String text, int from) {
        return Math.min(this.findNextWordStartBoundary(text, from), this.findNextWordEndBoundary(text, from));
    }

    public int findNextWordStartBoundary(String var1, int var2);

    public int findNextWordEndBoundary(String var1, int var2);

    default public int findPreviousWordBoundary(String text, int from) {
        return Math.max(this.findPreviousWordStartBoundary(text, from), this.findPreviousWordEndBoundary(text, from));
    }

    public int findPreviousWordStartBoundary(String var1, int var2);

    public int findPreviousWordEndBoundary(String var1, int var2);

    default public TextareaRange findWordAt(String text, int pos) {
        IWordMatcher.checkBounds(text, pos);
        if (this.isWordStartBoundary(text, pos)) {
            int end = this.findNextWordEndBoundary(text, pos);
            if (end < 0) {
                return TextareaRange.INVALID_RANGE;
            }
            return new TextareaRange(pos, end);
        }
        if (this.isWordEndBoundary(text, pos)) {
            int start = this.findPreviousWordStartBoundary(text, pos);
            if (start < 0) {
                return TextareaRange.INVALID_RANGE;
            }
            return new TextareaRange(start, pos);
        }
        int start = this.findPreviousWordStartBoundary(text, pos);
        int end = this.findNextWordEndBoundary(text, pos);
        if (start < 0 || end < 0) {
            return TextareaRange.INVALID_RANGE;
        }
        return new TextareaRange(start, end);
    }

    default public boolean isWordAt(String text, int pos) {
        return this.isWordBoundary(text, pos) || this.findPreviousWordEndBoundary(text, pos) < this.findPreviousWordStartBoundary(text, pos);
    }

    default public boolean isWordBoundary(String text, int pos) {
        return this.isWordStartBoundary(text, pos) || this.isWordEndBoundary(text, pos);
    }

    default public boolean isWordStartBoundary(String text, int pos) {
        IWordMatcher.checkBounds(text, pos);
        if (text == null || text.isEmpty()) {
            return false;
        }
        if (pos == 0) {
            return this.findPreviousWordStartBoundary(text, pos + 1) == pos;
        }
        return this.findNextWordStartBoundary(text, pos - 1) == pos;
    }

    default public boolean isWordEndBoundary(String text, int pos) {
        IWordMatcher.checkBounds(text, pos);
        if (text == null || text.isEmpty()) {
            return false;
        }
        if (pos == text.length()) {
            return this.findNextWordEndBoundary(text, pos - 1) == pos;
        }
        return this.findPreviousWordEndBoundary(text, pos + 1) == pos;
    }

    default public boolean isLineBreakCanditate(String text, int pos) {
        return this.isWordStartBoundary(text, pos);
    }

    default public int findPreviousLineBreakCanditate(String text, int pos) {
        return this.findPreviousWordStartBoundary(text, pos);
    }

    default public int findNextLineBreakCanditate(String text, int pos) {
        return this.findNextWordStartBoundary(text, pos);
    }

    default public String trimToWidth(String text, int width) {
        int pe;
        String r = GuiRenderHelper.instance.font.func_78269_a(text, width);
        if (r == null || r.length() == 0) {
            return text;
        }
        if (!this.isLineBreakCanditate(text, r.length()) && (pe = this.findPreviousLineBreakCanditate(text, r.length())) > 0 && pe < r.length()) {
            return text.substring(0, pe);
        }
        return r;
    }

    public static void checkBounds(String text, int pos) {
        if (pos < 0 || pos > text.length()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

