/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls.gui.custom;

import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBoxExtension;
import com.creativemd.creativecore.common.gui.controls.gui.custom.GuiStackSelectorExtension;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class GuiStackSelector
extends GuiComboBox {
    protected HashMapList<String, ItemStack> stacks;
    public EntityPlayer player;
    public boolean searchBar;
    protected ItemStack selected = ItemStack.field_190927_a;

    public GuiStackSelector(String name, int x, int y, int width, EntityPlayer player, boolean searchBar) {
        super(name, x, y, width, new ArrayList<String>());
        this.searchBar = searchBar;
        this.player = player;
        this.updateCollectedStacks();
        this.selectFirst();
    }

    public boolean selectFirst() {
        ItemStack first;
        if (this.stacks != null && (first = this.stacks.getFirst()) != null) {
            this.setSelected(first);
            return true;
        }
        return false;
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    protected abstract HashMapList<String, ItemStack> collectItems();

    public void updateCollectedStacks() {
        this.stacks = this.collectItems();
    }

    public boolean setSelected(ItemStack stack) {
        if (this.stacks.contains(stack)) {
            String display;
            try {
                display = stack.func_82833_r();
            }
            catch (Exception e) {
                display = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).toString();
            }
            this.caption = display;
            this.selected = stack;
            this.raiseEvent(new GuiControlChangedEvent(this));
            return true;
        }
        return false;
    }

    public HashMapList<String, ItemStack> getStacks() {
        return this.stacks;
    }

    public ItemStack getSelected() {
        return this.selected;
    }

    @Override
    protected int getAdditionalSize() {
        return 22;
    }

    @Override
    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        super.renderContent(helper, style, width, height);
        ItemStack stack = this.getSelected();
        if (!stack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(width / 2 - (helper.getStringWidth(this.caption) + this.getAdditionalSize()) / 2), (float)(height / 2 - 8), (float)0.0f);
            helper.drawItemStack(stack, 0, 0, 16, 16);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    protected GuiComboBoxExtension createBox() {
        return new GuiStackSelectorExtension(this.name + "extension", this.getPlayer(), this.posX, this.posY + this.height, this.width - this.getContentOffset() * 2, 80, this);
    }

    @Override
    public boolean select(String line) {
        return false;
    }
}

