/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls.container;

import com.creativemd.creativecore.common.gui.ContainerControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.container.client.GuiSlotControl;
import com.creativemd.creativecore.common.gui.event.container.SlotChangeEvent;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SlotControl
extends ContainerControl {
    public Slot slot;
    public ItemStack lastSended = ItemStack.field_190927_a;

    public SlotControl(Slot slot) {
        super(slot.field_75224_c.func_70005_c_() + slot.getSlotIndex());
        this.slot = slot;
        this.lastSended = slot.func_75211_c().func_77946_l();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiControl createGuiControl() {
        GuiSlotControl control = new GuiSlotControl(this.slot.field_75223_e, this.slot.field_75221_f, this);
        control.enabled = this.enabled;
        return control;
    }

    @Override
    public void onTick() {
        if (!this.isRemote() && !ItemStack.func_77989_b((ItemStack)this.lastSended, (ItemStack)this.slot.func_75211_c())) {
            this.sendUpdate();
            this.raiseEvent(new SlotChangeEvent(this));
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        return stack.func_77976_d();
    }

    public int getStackLimit(Slot slot, ItemStack stack) {
        return Math.min(slot.func_75219_a(), this.getItemStackLimit(stack));
    }

    @Override
    public void writeToNBTUpdate(NBTTagCompound nbt) {
        ItemStack stack = this.slot.func_75211_c();
        if (this.slot.func_75216_d()) {
            stack.func_77955_b(nbt);
            if (stack.func_190916_E() > 127) {
                nbt.func_74768_a("realCount", stack.func_190916_E());
            }
            this.lastSended = stack.func_77946_l();
        } else {
            this.lastSended = ItemStack.field_190927_a;
        }
        NBTTagCompound dragSlot = new NBTTagCompound();
        if (!this.getPlayer().field_71071_by.func_70445_o().func_190926_b()) {
            this.getPlayer().field_71071_by.func_70445_o().func_77955_b(dragSlot);
        }
        nbt.func_74782_a("drag", (NBTBase)dragSlot);
    }

    @Override
    public void onPacketReceive(NBTTagCompound nbt) {
        switch (nbt.func_74762_e("type")) {
            case 0: {
                if (!this.isRemote()) {
                    System.out.println("Client is sending stuff!");
                }
                ItemStack stack = ItemStack.field_190927_a;
                if (nbt.func_74764_b("id")) {
                    stack = new ItemStack(nbt);
                    if (nbt.func_74764_b("realCount")) {
                        stack.func_190920_e(nbt.func_74762_e("realCount"));
                    }
                }
                this.slot.func_75215_d(stack);
                if (!ItemStack.func_77989_b((ItemStack)this.lastSended, (ItemStack)this.slot.func_75211_c())) {
                    this.raiseEvent(new SlotChangeEvent(this));
                }
                this.lastSended = stack;
                ItemStack dragStack = ItemStack.field_190927_a;
                if (nbt.func_74764_b("drag")) {
                    dragStack = new ItemStack(nbt.func_74775_l("drag"));
                }
                this.getPlayer().field_71071_by.func_70437_b(dragStack);
                break;
            }
            case 1: {
                this.onSlotClicked(nbt.func_74762_e("button"), nbt.func_74767_n("shift"), nbt.func_74762_e("scrolled"));
                break;
            }
            case 2: {
                this.dropItem(nbt.func_74767_n("ctrl"));
                break;
            }
            case 3: {
                this.splitStack(nbt.func_74759_k("slots"), this.getPlayer().field_71071_by.func_70445_o(), nbt.func_74767_n("right"));
            }
        }
    }

    public void dropItem(boolean ctrl) {
        if (this.slot.func_75216_d()) {
            ItemStack drop = this.slot.func_75211_c().func_77946_l();
            if (ctrl) {
                this.slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                drop.func_190920_e(1);
                ItemStack newStack = this.slot.func_75211_c();
                newStack.func_190918_g(1);
            }
            this.getPlayer().func_71019_a(drop, true);
            this.slot.func_190901_a(this.getPlayer(), drop);
        }
    }

    public ItemStack putItemInSlot(Slot slot, ItemStack stack) {
        boolean canStack = Container.func_94527_a((Slot)slot, (ItemStack)stack, (boolean)true);
        int availableStackSize = this.getStackLimit(slot, stack);
        if (canStack && slot.func_75214_a(stack)) {
            int additionalStackSize;
            int neededStackSize = stack.func_190916_E();
            if (slot.func_75216_d()) {
                availableStackSize -= slot.func_75211_c().func_190916_E();
            }
            if ((additionalStackSize = Math.min(availableStackSize, neededStackSize)) > 0) {
                ItemStack inSlot = stack.func_77946_l();
                inSlot.func_190920_e(additionalStackSize);
                if (slot.func_75216_d()) {
                    inSlot.func_190917_f(slot.func_75211_c().func_190916_E());
                }
                slot.func_75215_d(inSlot);
                stack.func_190918_g(additionalStackSize);
            }
        }
        return stack;
    }

    public void switchItems() {
        ItemStack hand = this.getPlayer().field_71071_by.func_70445_o();
        InventoryPlayer inventoryplayer = this.getPlayer().field_71071_by;
        ItemStack slotItem = this.slot.func_75211_c();
        if (this.slot.func_75214_a(hand)) {
            boolean canStack = Container.func_94527_a((Slot)this.slot, (ItemStack)hand, (boolean)true);
            int stackLimit = this.getStackLimit(this.slot, hand);
            if (canStack) {
                int neededStackSize = hand.func_190916_E();
                if (this.slot.func_75216_d()) {
                    stackLimit -= slotItem.func_190916_E();
                }
                int usedStackSize = Math.min(stackLimit, neededStackSize);
                ItemStack inSlot = hand.func_77946_l();
                inSlot.func_190920_e(usedStackSize);
                if (this.slot.func_75216_d()) {
                    inSlot.func_190917_f(slotItem.func_190916_E());
                }
                this.slot.func_75215_d(inSlot);
                int left = Math.max(0, neededStackSize - usedStackSize);
                hand.func_190920_e(left);
            } else if (this.slot.func_82869_a(this.getPlayer()) && hand.func_190916_E() <= stackLimit && slotItem.func_190916_E() <= this.getItemStackLimit(slotItem)) {
                this.slot.func_75215_d(hand);
                inventoryplayer.func_70437_b(slotItem);
            }
        }
    }

    public boolean canMergeIntoInventory(Slot mergeSlot) {
        return mergeSlot.field_75224_c != this.slot.field_75224_c;
    }

    public void mergeToOtherInventory(ItemStack toTransfer, boolean useEmptySlot) {
        for (int i = 0; i < this.getParent().controls.size(); ++i) {
            Slot mergeSlot;
            if (!(this.getParent().controls.get(i) instanceof SlotControl) || !this.canMergeIntoInventory(mergeSlot = ((SlotControl)this.getParent().controls.get((int)i)).slot) || !useEmptySlot && !mergeSlot.func_75216_d() || !(toTransfer = ((SlotControl)this.getParent().controls.get(i)).putItemInSlot(mergeSlot, toTransfer)).func_190926_b()) continue;
            return;
        }
    }

    public void transferIntoOtherInventory(boolean reverse, int amount) {
        if (this.slot.func_75216_d()) {
            ItemStack stack = this.slot.func_75211_c();
            if (reverse) {
                int stackSizeLeft = Math.min(amount, stack.func_190916_E());
                for (int i = 0; i < this.getParent().controls.size(); ++i) {
                    boolean canStack;
                    if (!(this.getParent().controls.get(i) instanceof SlotControl)) continue;
                    Slot mergeSlot = ((SlotControl)this.getParent().controls.get((int)i)).slot;
                    if (mergeSlot.field_75224_c == this.slot.field_75224_c || !(canStack = Container.func_94527_a((Slot)mergeSlot, (ItemStack)stack, (boolean)true)) || !mergeSlot.func_75216_d() || mergeSlot.func_75211_c().func_190926_b()) continue;
                    int transfer = Math.min(stackSizeLeft, ((SlotControl)this.getParent().controls.get(i)).getStackLimit(this.slot, stack));
                    stack.func_190917_f(transfer);
                    mergeSlot.func_75211_c().func_190918_g(transfer);
                    if ((stackSizeLeft -= transfer) > 0) continue;
                    return;
                }
            } else {
                this.transferIntoOtherInventory(amount);
            }
        }
    }

    public void transferIntoOtherInventory(int amount) {
        ItemStack stack = this.slot.func_75211_c();
        if (amount > stack.func_190916_E()) {
            amount = stack.func_190916_E();
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(amount);
        int minAmount = stack.func_190916_E() - amount;
        this.mergeToOtherInventory(copy, false);
        if (!copy.func_190926_b()) {
            this.mergeToOtherInventory(copy, true);
        }
        if (copy.func_190926_b()) {
            stack.func_190920_e(minAmount);
        } else {
            stack.func_190918_g(amount - copy.func_190916_E());
        }
    }

    public void takeStack(boolean leftClick, InventoryPlayer inventoryplayer) {
        ItemStack hand = this.getPlayer().field_71071_by.func_70445_o();
        ItemStack slotItem = this.slot.func_75211_c();
        if (leftClick) {
            int stackSize = Math.min(Math.min(slotItem.func_190916_E(), slotItem.func_77976_d()), slotItem.func_190916_E());
            ItemStack newHand = slotItem.func_77946_l();
            newHand.func_190920_e(stackSize);
            inventoryplayer.func_70437_b(newHand);
            slotItem.func_190918_g(stackSize);
            this.slot.func_190901_a(this.getPlayer(), newHand);
        } else {
            int amount = (slotItem.func_190916_E() + 1) / 2;
            hand = this.slot.func_75209_a(amount);
            inventoryplayer.func_70437_b(hand);
            this.slot.func_190901_a(this.getPlayer(), hand);
        }
    }

    public void onSlotClicked(int mouseButton, boolean shift, int scrolled) {
        ItemStack hand = this.getPlayer().field_71071_by.func_70445_o();
        InventoryPlayer inventoryplayer = this.getPlayer().field_71071_by;
        ItemStack slotItem = this.slot.func_75211_c();
        boolean isWheel = false;
        if (mouseButton == 0) {
            if (this.slot.func_82869_a(this.getPlayer())) {
                if (shift) {
                    this.transferIntoOtherInventory(false, 64);
                } else if (!hand.func_190926_b()) {
                    this.switchItems();
                } else if (this.slot.func_75216_d()) {
                    this.takeStack(true, inventoryplayer);
                }
            }
        } else if (mouseButton == 1) {
            if (!hand.func_190926_b()) {
                if (this.slot.func_75214_a(hand)) {
                    boolean canStack = Container.func_94527_a((Slot)this.slot, (ItemStack)hand, (boolean)true);
                    if (canStack) {
                        int stacksize = 1;
                        if (this.slot.func_75216_d()) {
                            stacksize += slotItem.func_190916_E();
                        }
                        stacksize = Math.min(stacksize, this.getStackLimit(this.slot, hand));
                        if (this.slot.func_75216_d() && stacksize > slotItem.func_190916_E() || !this.slot.func_75216_d() && stacksize > 0) {
                            ItemStack inSlot = hand.func_77946_l();
                            inSlot.func_190920_e(stacksize);
                            this.slot.func_75215_d(inSlot);
                            hand.func_190918_g(1);
                        }
                    } else {
                        this.switchItems();
                    }
                }
            } else if (this.slot.func_75216_d() && this.slot.func_82869_a(this.getPlayer())) {
                this.takeStack(false, inventoryplayer);
            }
        } else if (mouseButton == 2) {
            if (hand.func_190926_b() && this.slot.func_75216_d() && this.getPlayer().field_71075_bZ.field_75098_d) {
                ItemStack stack = slotItem.func_77946_l();
                stack.func_190920_e(this.getItemStackLimit(stack));
                inventoryplayer.func_70437_b(stack);
            }
        } else if (mouseButton == 3 && (scrolled == 1 || this.slot.func_82869_a(this.getPlayer()))) {
            this.transferIntoOtherInventory(scrolled == -1, 1);
        }
    }

    public void splitStack(int[] slots, ItemStack stack, boolean isRightClick) {
        stack = stack.func_77946_l();
        int StackPerSlot = MathHelper.func_76141_d((float)((float)stack.func_190916_E() / (float)slots.length));
        if (isRightClick) {
            StackPerSlot = 1;
        }
        for (int i = 0; i < slots.length; ++i) {
            int use;
            SlotControl control = (SlotControl)this.getParent().controls.get(slots[i]);
            int stackSize = control.getStackLimit(control.slot, stack);
            if (control.slot.func_75216_d()) {
                stackSize -= control.slot.func_75211_c().func_190916_E();
            }
            if ((use = Math.min(StackPerSlot, Math.min(stackSize, stack.func_190916_E()))) > 0) {
                int size = use;
                if (control.slot.func_75216_d()) {
                    size += control.slot.func_75211_c().func_190916_E();
                }
                ItemStack inSlot = stack.func_77946_l();
                inSlot.func_190920_e(size);
                control.slot.func_75215_d(inSlot);
            }
            stack.func_190918_g(use);
        }
        this.getPlayer().field_71071_by.func_70437_b(stack.func_77946_l());
    }
}

