/*
 * Decompiled with CFR 0.152.
 */
package dmfmm.catwalks.tileentity;

import dmfmm.catwalks.client.catwalks.CatwalkModel;
import dmfmm.catwalks.client.catwalks.CatwalkState;
import dmfmm.catwalks.tileentity.CatwalkTile;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CatwalkStateCalculator {
    static HashMap<World, HashMap<Long, CatwalkTile>> tileCache = new HashMap();
    World world;
    BlockPos pos;

    public static void removeFromCache(World world, BlockPos pos) {
        HashMap<Long, CatwalkTile> hashMap;
        if (tileCache.containsKey(world) && (hashMap = tileCache.get(world)).containsKey(pos.func_177986_g())) {
            hashMap.remove(pos.func_177986_g());
        }
    }

    public CatwalkStateCalculator(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    @Nullable
    public CatwalkTile getCached(BlockPos pos) {
        long l = pos.func_177986_g();
        if (tileCache.containsKey(this.world)) {
            HashMap<Long, CatwalkTile> hashMap = tileCache.get(this.world);
            if (hashMap.containsKey(l)) {
                return hashMap.get(l);
            }
            TileEntity tileEntity = this.world.func_175625_s(pos);
            if (tileEntity instanceof CatwalkTile) {
                hashMap.put(l, (CatwalkTile)tileEntity);
                return (CatwalkTile)tileEntity;
            }
        } else {
            HashMap<Long, CatwalkTile> hashMap = new HashMap<Long, CatwalkTile>();
            TileEntity tileEntity = this.world.func_175625_s(pos);
            if (tileEntity instanceof CatwalkTile) {
                hashMap.put(l, (CatwalkTile)tileEntity);
                tileCache.put(this.world, hashMap);
                return (CatwalkTile)tileEntity;
            }
        }
        return null;
    }

    public boolean exists(BlockPos pos) {
        return this.getCached(pos) != null;
    }

    public boolean has(EnumFacing side) {
        return this.has(side, this.pos);
    }

    public boolean has(EnumFacing side, BlockPos pos) {
        return this.getCached(pos).has(side);
    }

    public CatwalkState calculate() {
        return new CatwalkState(this.getRailState(EnumFacing.WEST, EnumFacing.NORTH), this.getRailState(EnumFacing.EAST, EnumFacing.NORTH), this.getRailState(EnumFacing.WEST, EnumFacing.SOUTH), this.getRailState(EnumFacing.EAST, EnumFacing.SOUTH), !this.has(EnumFacing.DOWN) ? null : this.getFloorState(EnumFacing.WEST, EnumFacing.NORTH), !this.has(EnumFacing.DOWN) ? null : this.getFloorState(EnumFacing.EAST, EnumFacing.NORTH), !this.has(EnumFacing.DOWN) ? null : this.getFloorState(EnumFacing.WEST, EnumFacing.SOUTH), !this.has(EnumFacing.DOWN) ? null : this.getFloorState(EnumFacing.EAST, EnumFacing.SOUTH), new int[0]);
    }

    public CatwalkModel.RailSection getRailState(EnumFacing xAxis, EnumFacing zAxis) {
        BlockPos posX = this.pos.func_177972_a(xAxis);
        BlockPos posZ = this.pos.func_177972_a(zAxis);
        BlockPos corner = this.pos.func_177972_a(xAxis).func_177972_a(zAxis);
        if (this.has(xAxis) && this.has(zAxis)) {
            return CatwalkModel.RailSection.OUTER;
        }
        if (this.has(xAxis)) {
            if (this.exists(posZ) && !this.has(zAxis.func_176734_d(), posZ)) {
                if (this.has(xAxis, posZ)) {
                    return CatwalkModel.RailSection.Z_EDGE;
                }
                if (this.exists(corner) && this.has(zAxis.func_176734_d(), corner) && !this.has(xAxis.func_176734_d(), corner)) {
                    return CatwalkModel.RailSection.Z_EDGE;
                }
            }
            return CatwalkModel.RailSection.Z_END;
        }
        if (this.has(zAxis)) {
            if (this.exists(posX) && !this.has(xAxis.func_176734_d(), posX)) {
                if (this.has(zAxis, posX)) {
                    return CatwalkModel.RailSection.X_EDGE;
                }
                if (this.exists(corner) && this.has(xAxis.func_176734_d(), corner) && !this.has(zAxis.func_176734_d(), corner)) {
                    return CatwalkModel.RailSection.X_EDGE;
                }
            }
            return CatwalkModel.RailSection.X_END;
        }
        if (!this.has(xAxis) && !this.has(zAxis) && this.exists(posX) && !this.has(xAxis.func_176734_d(), posX) && this.has(zAxis, posX) && this.exists(posZ) && !this.has(zAxis.func_176734_d(), posZ) && this.has(xAxis, posZ)) {
            return CatwalkModel.RailSection.INNER;
        }
        return CatwalkModel.RailSection.MIDDLE;
    }

    public CatwalkModel.FloorSection getFloorState(EnumFacing xAxis, EnumFacing zAxis) {
        BlockPos posX = this.pos.func_177972_a(xAxis);
        BlockPos posZ = this.pos.func_177972_a(zAxis);
        BlockPos corner = this.pos.func_177972_a(xAxis).func_177972_a(zAxis);
        if (this.has(xAxis) && this.has(zAxis)) {
            return CatwalkModel.FloorSection.OUTER;
        }
        if (!this.has(xAxis) && !this.has(zAxis) && this.exists(posX) && this.has(EnumFacing.DOWN, posX) && !this.has(xAxis.func_176734_d(), posX) && this.exists(posZ) && this.has(EnumFacing.DOWN, posZ) && !this.has(zAxis.func_176734_d(), posZ)) {
            if (this.exists(corner) && this.has(EnumFacing.DOWN, corner) && !this.has(xAxis.func_176734_d(), corner) && !this.has(zAxis.func_176734_d(), corner)) {
                return CatwalkModel.FloorSection.MIDDLE;
            }
            return CatwalkModel.FloorSection.INNER;
        }
        if (!this.has(zAxis) && this.exists(posZ) && this.has(EnumFacing.DOWN, posZ) && !this.has(zAxis.func_176734_d(), posZ)) {
            return CatwalkModel.FloorSection.Z_EDGE;
        }
        if (!this.has(xAxis) && this.exists(posX) && this.has(EnumFacing.DOWN, posX) && !this.has(xAxis.func_176734_d(), posX)) {
            return CatwalkModel.FloorSection.X_EDGE;
        }
        return CatwalkModel.FloorSection.OUTER;
    }
}

