/*
 * Decompiled with CFR 0.152.
 */
package dmfmm.catwalks.block;

import dmfmm.catwalks.Catwalks;
import dmfmm.catwalks.block.GenericBlock;
import dmfmm.catwalks.client.catwalks.CatwalkState;
import dmfmm.catwalks.item.ItemBlockCatwalk;
import dmfmm.catwalks.registry.ItemRegistry;
import dmfmm.catwalks.tileentity.CatwalkStateCalculator;
import dmfmm.catwalks.tileentity.CatwalkTile;
import dmfmm.catwalks.tileentity.IConnectTile;
import dmfmm.catwalks.utils.CatwalkMaterial;
import dmfmm.catwalks.utils.ICustomItemBlock;
import dmfmm.catwalks.utils.Pair;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CatwalkBlock
extends GenericBlock
implements ITileEntityProvider,
ICustomItemBlock {
    public static final IUnlistedProperty<CatwalkState> CATWALK_STATE = new IUnlistedProperty<CatwalkState>(){

        public String getName() {
            return "cablestate";
        }

        public boolean isValid(CatwalkState value) {
            return true;
        }

        public Class<CatwalkState> getType() {
            return CatwalkState.class;
        }

        public String valueToString(CatwalkState value) {
            return value.toString().toLowerCase();
        }
    };
    public static PropertyEnum<CatwalkMaterial> MATERIAL = PropertyEnum.func_177709_a((String)"material", CatwalkMaterial.class);
    private static Map<EnumFacing, Pair<AxisAlignedBB, AxisAlignedBB>> boundingBoxes = new HashMap<EnumFacing, Pair<AxisAlignedBB, AxisAlignedBB>>();
    private AxisAlignedBB bounds = field_185505_j;

    private static double p(int pixels) {
        return (double)pixels / 16.0;
    }

    private static AxisAlignedBB aabb(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return new AxisAlignedBB(CatwalkBlock.p(minX), CatwalkBlock.p(minY), CatwalkBlock.p(minZ), CatwalkBlock.p(maxX), CatwalkBlock.p(maxY), CatwalkBlock.p(maxZ));
    }

    public CatwalkBlock() {
        super("catwalk");
        this.func_149672_a(SoundType.field_185852_e);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_184586_b(hand).func_77973_b() != ItemRegistry.BLOW_TORCH) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof CatwalkTile)) {
            return false;
        }
        ((CatwalkTile)tileEntity).updateSide(facing, !((CatwalkTile)tileEntity).getSideState(facing));
        world.func_184138_a(pos, state, state, 2);
        return true;
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        CatwalkTile tile = worldIn.func_175625_s(pos) instanceof CatwalkTile ? (CatwalkTile)worldIn.func_175625_s(pos) : null;
        HashMap<Pair<EnumFacing, AxisAlignedBB>, RayTraceResult> map = new HashMap<Pair<EnumFacing, AxisAlignedBB>, RayTraceResult>();
        for (Map.Entry<EnumFacing, Pair<AxisAlignedBB, AxisAlignedBB>> it : boundingBoxes.entrySet()) {
            boolean has = tile.has(it.getKey());
            AxisAlignedBB bb = has ? it.getValue().getKey() : it.getValue().getValue();
            map.put(new Pair<EnumFacing, AxisAlignedBB>(it.getKey(), bb), this.func_185503_a(pos, start, end, bb));
        }
        Optional<Map.Entry> min = map.entrySet().stream().filter(x -> x.getValue() != null).min(Comparator.comparingDouble(p -> ((RayTraceResult)p.getValue()).field_72307_f.func_189985_c()));
        if (min.isPresent()) {
            Map.Entry pairRayTraceResultEntry = min.get();
            RayTraceResult traceResult = new RayTraceResult(((RayTraceResult)pairRayTraceResultEntry.getValue()).field_72313_a, ((RayTraceResult)pairRayTraceResultEntry.getValue()).field_72307_f, (EnumFacing)((Pair)pairRayTraceResultEntry.getKey()).getKey(), ((RayTraceResult)pairRayTraceResultEntry.getValue()).func_178782_a());
            Pair savedPair = (Pair)pairRayTraceResultEntry.getKey();
            if (Catwalks.side == Side.CLIENT) {
                this.updateBounds((AxisAlignedBB)savedPair.getValue());
            }
            return traceResult;
        }
        return null;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof CatwalkTile) {
            CatwalkTile tile = (CatwalkTile)tileEntity;
            if (stack != ItemStack.field_190927_a && stack.func_77942_o() && stack.func_77978_p().func_74764_b("material")) {
                String materialName = stack.func_77978_p().func_74779_i("material");
                try {
                    CatwalkMaterial mat = CatwalkMaterial.valueOf(materialName.toUpperCase());
                    tile.updateMaterial(mat.func_176610_l());
                }
                catch (IllegalArgumentException e) {
                    System.out.println("ass");
                }
            }
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                TileEntity other = world.func_175625_s(pos.func_177972_a(facing));
                if (other instanceof CatwalkTile) {
                    ((CatwalkTile)other).updateSide(facing.func_176734_d(), false);
                    tile.updateSide(facing, false);
                }
                if (!(other instanceof IConnectTile)) continue;
                tile.updateSide(facing, false);
            }
        }
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        super.func_176206_d(world, pos, state);
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            TileEntity other = world.func_175625_s(pos.func_177972_a(facing));
            if (!(other instanceof CatwalkTile)) continue;
            ((CatwalkTile)other).updateSide(facing.func_176734_d(), true);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        CatwalkStateCalculator.removeFromCache(world, pos);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (te == null) {
            super.func_180657_a(worldIn, player, pos, state, null, stack);
        } else if (te instanceof CatwalkTile) {
            stack = new ItemStack((Block)this, 1);
            CatwalkMaterial mat = ((CatwalkTile)te).getMaterial();
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("material", mat.func_176610_l().toLowerCase());
            stack.func_77982_d(tag);
            CatwalkBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IUnlistedProperty[]{CATWALK_STATE}).add(new IProperty[]{MATERIAL}).build();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState s = super.func_176221_a(state, worldIn, pos);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof CatwalkTile) {
            s = s.func_177226_a(MATERIAL, (Comparable)((Object)((CatwalkTile)tileEntity).getMaterial()));
        }
        return s;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        IExtendedBlockState estate = (IExtendedBlockState)super.getExtendedState(state, world, pos);
        if (tileEntity instanceof CatwalkTile) {
            estate = estate.withProperty(CATWALK_STATE, (Object)((CatwalkTile)tileEntity).getCatwalkState());
        }
        return estate;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof CatwalkTile) {
            for (EnumFacing facing : boundingBoxes.keySet()) {
                AxisAlignedBB bb;
                boolean exists = ((CatwalkTile)tileEntity).getSideState(facing);
                if (!exists || !(bb = boundingBoxes.get(facing).getKey().func_186670_a(pos)).func_72326_a(entityBox)) continue;
                collidingBoxes.add(bb);
            }
        }
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new CatwalkTile();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.bounds;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateBounds(AxisAlignedBB bb) {
        this.bounds = bb;
    }

    @Override
    public ItemBlock getCustomItemBlock() {
        return new ItemBlockCatwalk();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof CatwalkTile) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("material", ((CatwalkTile)tileEntity).getMaterial().func_176610_l());
            ItemStack is = new ItemStack((Block)this, 1);
            is.func_77982_d(nbt);
            return is;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    static {
        boundingBoxes.put(EnumFacing.DOWN, new Pair<AxisAlignedBB, AxisAlignedBB>(CatwalkBlock.aabb(0, 0, 0, 16, 0, 16), CatwalkBlock.aabb(4, 0, 4, 12, 0, 12)));
        boundingBoxes.put(EnumFacing.NORTH, new Pair<AxisAlignedBB, AxisAlignedBB>(CatwalkBlock.aabb(0, 0, 0, 16, 16, 0), CatwalkBlock.aabb(0, 0, 0, 16, 8, 0)));
        boundingBoxes.put(EnumFacing.SOUTH, new Pair<AxisAlignedBB, AxisAlignedBB>(CatwalkBlock.aabb(0, 0, 16, 16, 16, 16), CatwalkBlock.aabb(0, 0, 16, 16, 8, 16)));
        boundingBoxes.put(EnumFacing.WEST, new Pair<AxisAlignedBB, AxisAlignedBB>(CatwalkBlock.aabb(0, 0, 0, 0, 16, 16), CatwalkBlock.aabb(0, 0, 0, 0, 8, 16)));
        boundingBoxes.put(EnumFacing.EAST, new Pair<AxisAlignedBB, AxisAlignedBB>(CatwalkBlock.aabb(16, 0, 0, 16, 16, 16), CatwalkBlock.aabb(16, 0, 0, 16, 8, 16)));
    }
}

