/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.item;

import java.util.List;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedauto.PackagedAuto;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IDistributorMarkerItem;
import thelm.packagedauto.client.IModelRegister;

public class ItemDistributorMarker
extends Item
implements IDistributorMarkerItem,
IModelRegister {
    public static final ItemDistributorMarker INSTANCE = new ItemDistributorMarker();
    public static final ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation("packagedauto:distributor_marker#inventory");
    public static final ModelResourceLocation MODEL_LOCATION_BOUND = new ModelResourceLocation("packagedauto:distributor_marker_bound#inventory");

    protected ItemDistributorMarker() {
        this.func_77655_b("packagedauto.distributor_marker");
        this.setRegistryName("packagedauto:distributor_marker");
        this.func_77637_a(PackagedAuto.CREATIVE_TAB);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!world.field_72995_K) {
            ItemStack stack = player.func_184586_b(hand);
            if (this.getDirectionalGlobalPos(stack) != null) {
                return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
            }
            int dim = world.field_73011_w.getDimension();
            if (stack.func_190916_E() > 1) {
                ItemStack stack1 = stack.func_77979_a(1);
                if (!stack1.func_77942_o()) {
                    stack1.func_77982_d(new NBTTagCompound());
                }
                NBTTagCompound tag = stack1.func_77978_p();
                tag.func_74768_a("Dimension", dim);
                tag.func_74783_a("Position", new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
                tag.func_74774_a("Direction", (byte)side.func_176745_a());
                if (!player.field_71071_by.func_70441_a(stack1)) {
                    EntityItem item = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack1);
                    item.func_145799_b(player.func_70005_c_());
                    world.func_72838_d((Entity)item);
                }
            } else {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                NBTTagCompound tag = stack.func_77978_p();
                tag.func_74768_a("Dimension", dim);
                tag.func_74783_a("Position", new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
                tag.func_74774_a("Direction", (byte)side.func_176745_a());
            }
            return EnumActionResult.SUCCESS;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K && playerIn.func_70093_af()) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack((Item)INSTANCE, playerIn.func_184586_b(handIn).func_190916_E()));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        DirectionalGlobalPos pos = this.getDirectionalGlobalPos(stack);
        if (pos != null) {
            tooltip.add(I18n.func_74837_a((String)"item.packagedauto.distributor_marker.dimension", (Object[])new Object[]{pos.dimension()}));
            String posString = "[" + pos.x() + ", " + pos.y() + ", " + pos.z() + "]";
            tooltip.add(I18n.func_74837_a((String)"item.packagedauto.distributor_marker.position", (Object[])new Object[]{posString}));
            String dirString = I18n.func_74838_a((String)("misc.packagedauto." + pos.direction().func_176610_l()));
            tooltip.add(I18n.func_74837_a((String)"item.packagedauto.distributor_marker.direction", (Object[])new Object[]{dirString}));
        }
    }

    @Override
    public DirectionalGlobalPos getDirectionalGlobalPos(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("Dimension") && nbt.func_74764_b("Position") && nbt.func_74764_b("Direction")) {
            int dimension = nbt.func_74762_e("Dimension");
            int[] posArray = nbt.func_74759_k("Position");
            BlockPos blockPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
            EnumFacing direction = EnumFacing.func_82600_a((int)nbt.func_74771_c("Direction"));
            return new DirectionalGlobalPos(dimension, blockPos, direction);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> stack.func_77942_o() ? MODEL_LOCATION_BOUND : MODEL_LOCATION);
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{MODEL_LOCATION, MODEL_LOCATION_BOUND});
    }
}

