/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import thelm.packagedauto.inventory.InventoryTileBase;
import thelm.packagedauto.tile.TilePackager;
import thelm.packagedauto.tile.TilePackagerExtension;

public class InventoryPackagerExtension
extends InventoryTileBase {
    public final TilePackagerExtension tile;

    public InventoryPackagerExtension(TilePackagerExtension tile) {
        super(tile, 11);
        this.tile = tile;
        this.slots = IntStream.rangeClosed(0, 9).toArray();
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        if (!(index >= 9 || this.tile.func_145831_w().field_72995_K || !this.tile.isWorking || this.func_70301_a(index).func_190926_b() || !stack.func_190926_b() && stack.func_77969_a(this.func_70301_a(index)) && this.tile.isInputValid())) {
            this.tile.endProcess();
        }
        super.func_70299_a(index, stack);
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = super.func_70298_a(index, count);
        if (index < 9 && !this.tile.func_145831_w().field_72995_K && this.tile.isWorking && !this.func_70301_a(index).func_190926_b() && !this.tile.isInputValid()) {
            this.tile.endProcess();
        }
        return stack;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        switch (index) {
            case 9: {
                return false;
            }
            case 10: {
                return stack.hasCapability(CapabilityEnergy.ENERGY, null);
            }
        }
        return this.tile.isWorking ? !this.func_70301_a(index).func_190926_b() : true;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.tile.remainingProgress;
            }
            case 1: {
                return this.tile.isWorking ? 1 : 0;
            }
            case 2: {
                return this.tile.mode.ordinal();
            }
            case 3: {
                return this.tile.getEnergyStorage().getEnergyStored();
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.tile.remainingProgress = value;
                break;
            }
            case 1: {
                this.tile.isWorking = value != 0;
                break;
            }
            case 2: {
                this.tile.mode = TilePackager.Mode.values()[value];
                break;
            }
            case 3: {
                this.tile.getEnergyStorage().setEnergyStored(value);
            }
        }
    }

    @Override
    public int func_174890_g() {
        return 4;
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index < 9;
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 9 || direction == EnumFacing.UP && index != 10;
    }
}

