/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import com.google.common.primitives.Ints;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IDistributorMarkerItem;
import thelm.packagedauto.inventory.InventoryTileBase;
import thelm.packagedauto.tile.TileDistributor;

public class InventoryDistributor
extends InventoryTileBase {
    public final TileDistributor tile;

    public InventoryDistributor(TileDistributor tile) {
        super(tile, 81);
        this.tile = tile;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
        this.loadMarker(index);
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = super.func_70298_a(index, count);
        this.loadMarker(index);
        return stack;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack.func_77973_b() instanceof IDistributorMarkerItem && ((IDistributorMarkerItem)stack.func_77973_b()).getDirectionalGlobalPos(stack) != null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        for (int i = 0; i < 81; ++i) {
            this.loadMarker(i);
        }
    }

    public void loadMarker(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack.func_77973_b() instanceof IDistributorMarkerItem) {
            DirectionalGlobalPos pos = ((IDistributorMarkerItem)stack.func_77973_b()).getDirectionalGlobalPos(stack);
            if (pos == null) {
                this.tile.positions.remove(slot);
            } else if (this.tile.func_145831_w() != null && this.tile.func_145831_w().field_73011_w.getDimension() != pos.dimension()) {
                this.tile.positions.remove(slot);
            } else {
                BlockPos dirVec = pos.blockPos().func_177973_b((Vec3i)this.tile.func_174877_v());
                int dist = Ints.max((int[])new int[]{Math.abs(dirVec.func_177958_n()), Math.abs(dirVec.func_177956_o()), Math.abs(dirVec.func_177952_p())});
                if (dist <= TileDistributor.range) {
                    this.tile.positions.put(slot, (Object)pos);
                }
            }
        } else {
            this.tile.positions.remove(slot);
        }
    }
}

