/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.networking;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import net.minecraft.item.ItemStack;
import thelm.packagedauto.integration.appeng.networking.HostHelperTile;
import thelm.packagedauto.tile.TilePackager;

public class HostHelperTilePackager
extends HostHelperTile<TilePackager> {
    public HostHelperTilePackager(TilePackager tile) {
        super(tile);
    }

    public void ejectItem() {
        if (this.isActive()) {
            IGrid grid = this.getNode().getGrid();
            IStorageGrid storageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
            IEnergyGrid energyGrid = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
            IItemStorageChannel storageChannel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
            IMEMonitor inventory = storageGrid.getInventory((IStorageChannel)storageChannel);
            IAEItemStack stack = (IAEItemStack)storageChannel.createStack((Object)((TilePackager)this.tile).getInventory().func_70301_a(9));
            IAEItemStack rem = (IAEItemStack)AEApi.instance().storage().poweredInsert((IEnergySource)energyGrid, (IMEInventory)inventory, (IAEStack)stack, (IActionSource)this.source, Actionable.MODULATE);
            if (rem == null || rem.getStackSize() == 0L) {
                ((TilePackager)this.tile).getInventory().func_70299_a(9, ItemStack.field_190927_a);
            } else if (rem.getStackSize() < stack.getStackSize()) {
                ((TilePackager)this.tile).getInventory().func_70299_a(9, rem.createItemStack());
            }
        }
    }

    public void chargeEnergy() {
        if (this.isActive()) {
            IGrid grid = this.getNode().getGrid();
            IEnergyGrid energyGrid = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
            double conversion = PowerUnits.RF.convertTo(PowerUnits.AE, 1.0);
            int request = Math.min(((TilePackager)this.tile).getEnergyStorage().getMaxReceive(), ((TilePackager)this.tile).getEnergyStorage().getMaxEnergyStored() - ((TilePackager)this.tile).getEnergyStorage().getEnergyStored());
            double available = energyGrid.extractAEPower(((double)request + 0.5) * conversion, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            int extract = (int)(available / conversion);
            energyGrid.extractAEPower((double)extract * conversion, Actionable.MODULATE, PowerMultiplier.CONFIG);
            ((TilePackager)this.tile).getEnergyStorage().receiveEnergy(extract, false);
        }
    }

    public void postPatternChange() {
        if (this.isActive()) {
            IGrid grid = this.getNode().getGrid();
            grid.postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this.tile, this.getNode()));
        }
    }
}

