/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.api;

import java.util.Collections;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.ResourceLocation;
import thelm.packagedauto.api.IRecipeType;

public class RecipeTypeRegistry {
    private static final NavigableMap<ResourceLocation, IRecipeType> REGISTRY = new TreeMap<ResourceLocation, IRecipeType>();
    private static final IntIdentityHashBiMap<IRecipeType> IDS = new IntIdentityHashBiMap(4);
    private static int id = 0;

    private RecipeTypeRegistry() {
    }

    public static boolean registerRecipeType(IRecipeType type) {
        if (REGISTRY.containsKey(type.getName())) {
            return false;
        }
        REGISTRY.put(type.getName(), type);
        IDS.func_186808_c((Object)type);
        return true;
    }

    public static IRecipeType getRecipeType(ResourceLocation name) {
        return (IRecipeType)REGISTRY.get(name);
    }

    public static IRecipeType getRecipeType(int id) {
        return (IRecipeType)IDS.func_186813_a(id);
    }

    public static int getId(IRecipeType type) {
        return IDS.func_186815_a((Object)type);
    }

    public static NavigableMap<ResourceLocation, IRecipeType> getRegistry() {
        return Collections.unmodifiableNavigableMap(REGISTRY);
    }

    public static IRecipeType getNextRecipeType(IRecipeType type, boolean reverse) {
        int toGet = Math.floorMod(RecipeTypeRegistry.getId(type) + (!reverse ? 1 : -1), REGISTRY.size());
        IRecipeType ret = RecipeTypeRegistry.getRecipeType(toGet);
        return ret;
    }
}

