/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.igisereneseasons;

import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.tag.registry.TagRegistry;
import java.util.function.Function;
import net.xalcon.igisereneseasons.IGISereneSeasons;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.SeasonHelper;

public final class SereneSeasonTags {
    private static <T> void registerTag(String name, final Function<ISeasonState, T> callback) {
        TagRegistry.INSTANCE.register(new TagSereneSeasons(){

            public String getValue() {
                try {
                    return String.valueOf(callback.apply(SeasonHelper.dataProvider.getClientSeasonState()));
                }
                catch (Exception ex) {
                    IGISereneSeasons.logger.error((Object)ex);
                    return "ERROR";
                }
            }
        }.setName(name));
    }

    public static void register() {
        SereneSeasonTags.registerTag("sereneseasonsdayduration", ISeasonState::getDayDuration);
        SereneSeasonTags.registerTag("sereneseasonssubseasonduration", ISeasonState::getSubSeasonDuration);
        SereneSeasonTags.registerTag("sereneseasonsseasonduration", ISeasonState::getSeasonDuration);
        SereneSeasonTags.registerTag("sereneseasonscycleduration", ISeasonState::getCycleDuration);
        SereneSeasonTags.registerTag("sereneseasonsseasoncycleticks", ISeasonState::getSeasonCycleTicks);
        SereneSeasonTags.registerTag("sereneseasonsday", ISeasonState::getDay);
        SereneSeasonTags.registerTag("sereneseasonscurrentseason", s -> s.getSeason().name());
        SereneSeasonTags.registerTag("sereneseasonscurrentsubseason", s -> s.getSubSeason().name());
        SereneSeasonTags.registerTag("sereneseasonscurrenttropicalseason", ISeasonState::getDay);
        SereneSeasonTags.registerTag("sereneseasonscurrentseasonord", s -> s.getSeason().ordinal());
        SereneSeasonTags.registerTag("sereneseasonscurrentsubseasonord", s -> s.getSubSeason().ordinal());
        SereneSeasonTags.registerTag("sereneseasonsdayofseason", s -> s.getDay() % (s.getSeasonDuration() / s.getDayDuration()));
    }

    private static abstract class TagSereneSeasons
    extends Tag {
        private TagSereneSeasons() {
        }

        public String getCategory() {
            return "sereneseasons";
        }
    }
}

