/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.shaded.org.jctools.queues.atomic.unpadded;

import github.kasuminova.stellarcore.shaded.org.jctools.queues.MessagePassingQueue;
import github.kasuminova.stellarcore.shaded.org.jctools.queues.atomic.AtomicQueueUtil;
import github.kasuminova.stellarcore.shaded.org.jctools.queues.atomic.unpadded.BaseSpscLinkedAtomicUnpaddedArrayQueue;
import github.kasuminova.stellarcore.shaded.org.jctools.util.Pow2;
import github.kasuminova.stellarcore.shaded.org.jctools.util.RangeUtil;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class SpscChunkedAtomicUnpaddedArrayQueue<E>
extends BaseSpscLinkedAtomicUnpaddedArrayQueue<E> {
    private final int maxQueueCapacity;
    private long producerQueueLimit;

    public SpscChunkedAtomicUnpaddedArrayQueue(int capacity) {
        this(Math.max(8, Pow2.roundToPowerOfTwo(capacity / 8)), capacity);
    }

    public SpscChunkedAtomicUnpaddedArrayQueue(int chunkSize, int capacity) {
        AtomicReferenceArray buffer;
        RangeUtil.checkGreaterThanOrEqual(capacity, 16, "capacity");
        RangeUtil.checkGreaterThanOrEqual(chunkSize, 8, "chunkSize");
        this.maxQueueCapacity = Pow2.roundToPowerOfTwo(capacity);
        int chunkCapacity = Pow2.roundToPowerOfTwo(chunkSize);
        RangeUtil.checkLessThan(chunkCapacity, this.maxQueueCapacity, "chunkCapacity");
        long mask = chunkCapacity - 1;
        this.producerBuffer = buffer = AtomicQueueUtil.allocateRefArray(chunkCapacity + 1);
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerBufferLimit = mask - 1L;
        this.producerQueueLimit = this.maxQueueCapacity;
    }

    @Override
    final boolean offerColdPath(AtomicReferenceArray<E> buffer, long mask, long pIndex, int offset, E v, MessagePassingQueue.Supplier<? extends E> s) {
        long lookAheadStep = (mask + 1L) / 4L;
        long pBufferLimit = pIndex + lookAheadStep;
        long pQueueLimit = this.producerQueueLimit;
        if (pIndex >= pQueueLimit) {
            long cIndex = this.lvConsumerIndex();
            this.producerQueueLimit = pQueueLimit = cIndex + (long)this.maxQueueCapacity;
            if (pIndex >= pQueueLimit) {
                return false;
            }
        }
        if (pBufferLimit - pQueueLimit > 0L) {
            pBufferLimit = pQueueLimit;
        }
        if (pBufferLimit > pIndex + 1L && null == AtomicQueueUtil.lvRefElement(buffer, AtomicQueueUtil.calcCircularRefElementOffset(pBufferLimit, mask))) {
            this.producerBufferLimit = pBufferLimit - 1L;
            this.writeToQueue(buffer, v == null ? s.get() : v, pIndex, offset);
        } else if (null == AtomicQueueUtil.lvRefElement(buffer, AtomicQueueUtil.calcCircularRefElementOffset(pIndex + 1L, mask))) {
            this.writeToQueue(buffer, v == null ? s.get() : v, pIndex, offset);
        } else {
            AtomicReferenceArray newBuffer;
            this.producerBuffer = newBuffer = AtomicQueueUtil.allocateRefArray((int)(mask + 2L));
            this.linkOldToNew(pIndex, buffer, offset, newBuffer, offset, v == null ? s.get() : v);
        }
        return true;
    }

    @Override
    public int capacity() {
        return this.maxQueueCapacity;
    }
}

