/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.shaded.org.jctools.queues;

import github.kasuminova.stellarcore.shaded.org.jctools.queues.LinkedArrayQueueUtil;
import github.kasuminova.stellarcore.shaded.org.jctools.queues.MpscChunkedArrayQueue;
import github.kasuminova.stellarcore.shaded.org.jctools.util.Pow2;
import github.kasuminova.stellarcore.shaded.org.jctools.util.RangeUtil;

public class MpscGrowableArrayQueue<E>
extends MpscChunkedArrayQueue<E> {
    public MpscGrowableArrayQueue(int maxCapacity) {
        super(Math.max(2, Pow2.roundToPowerOfTwo(maxCapacity / 8)), maxCapacity);
    }

    public MpscGrowableArrayQueue(int initialCapacity, int maxCapacity) {
        super(initialCapacity, maxCapacity);
    }

    @Override
    protected int getNextBufferSize(E[] buffer) {
        long maxSize = this.maxQueueCapacity / 2L;
        RangeUtil.checkLessThanOrEqual(LinkedArrayQueueUtil.length(buffer), maxSize, "buffer.length");
        int newSize = 2 * (LinkedArrayQueueUtil.length(buffer) - 1);
        return newSize + 1;
    }

    @Override
    protected long getCurrentBufferCapacity(long mask) {
        return mask + 2L == this.maxQueueCapacity ? this.maxQueueCapacity : mask;
    }
}

