/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.minecraft.resources;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ModelLoader.class})
public class MixinModelLoader
extends ModelBakery {
    public MixinModelLoader() {
        super(null, null, null);
    }

    @Inject(method={"setupModelRegistry"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/TextureMap;loadSprites(Lnet/minecraft/client/resources/IResourceManager;Lnet/minecraft/client/renderer/texture/ITextureMapPopulator;)V")})
    private void injectSetupModelRegistryBeforeLoadSprites(CallbackInfoReturnable<IRegistry<ModelResourceLocation, IBakedModel>> cir, @Local(name={"textures"}) Set<ResourceLocation> textures) {
        String emissiveSuffix = MixinModelLoader.stellar_core$getEmissiveSuffix();
        textures.parallelStream().forEach(texture -> {
            String replacement;
            ResourceLocation resourceLocation = this.stellar_core$getResourceLocation((ResourceLocation)texture);
            Minecraft.func_71410_x().field_110450_ap.func_110589_b(resourceLocation);
            if (emissiveSuffix == null || emissiveSuffix.isEmpty()) {
                return;
            }
            String path = resourceLocation.func_110623_a();
            if (path.endsWith(replacement = emissiveSuffix + ".png")) {
                return;
            }
            Minecraft.func_71410_x().field_110450_ap.func_110589_b(new ResourceLocation(resourceLocation.func_110624_b(), path.replace(".png", replacement)));
        });
    }

    @Unique
    private ResourceLocation stellar_core$getResourceLocation(ResourceLocation loc) {
        String path = loc.func_110623_a().toLowerCase();
        boolean absPath = FMLClientHandler.instance().hasOptifine() && path.startsWith("mcpatcher/") || path.startsWith("optifine/");
        return absPath ? new ResourceLocation(loc.func_110624_b(), loc.func_110623_a() + ".png") : new ResourceLocation(loc.func_110624_b(), String.format("%s/%s%s", this.field_177609_j.getBasePath(), loc.func_110623_a(), ".png"));
    }

    @Unique
    private static String stellar_core$getEmissiveSuffix() {
        String suffixEmissive;
        Class<?> EmissiveTextures;
        if (!FMLClientHandler.instance().hasOptifine()) {
            return null;
        }
        try {
            EmissiveTextures = Class.forName("net.optifine.EmissiveTextures");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            suffixEmissive = (String)EmissiveTextures.getMethod("getSuffixEmissive", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            return null;
        }
        return suffixEmissive;
    }
}

