/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.minecraft.forge.parallelmodelloader;

import com.google.common.base.Joiner;
import github.kasuminova.stellarcore.client.model.ModelLoaderRegistryRef;
import github.kasuminova.stellarcore.client.model.ParallelModelLoaderAsyncBlackList;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.StellarLog;
import github.kasuminova.stellarcore.mixin.util.ConcurrentModelLoaderRegistry;
import github.kasuminova.stellarcore.shaded.org.jctools.maps.NonBlockingHashMap;
import github.kasuminova.stellarcore.shaded.org.jctools.maps.NonBlockingHashSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ModelLoaderRegistry.class}, remap=false)
public abstract class MixinModelLoaderRegistry
implements ConcurrentModelLoaderRegistry {
    @Unique
    private static final ThreadLocal<Deque<ResourceLocation>> stellar_core$LOADING_MODELS = ThreadLocal.withInitial(ArrayDeque::new);
    @Unique
    private static Map<ResourceLocation, IModel> stellar_core$cache = new NonBlockingHashMap<ResourceLocation, IModel>();
    @Unique
    private static Map<ResourceLocation, ResourceLocation> stellar_core$aliases = new NonBlockingHashMap<ResourceLocation, ResourceLocation>();
    @Unique
    private static Set<ResourceLocation> stellar_core$textures = new NonBlockingHashSet<ResourceLocation>();
    @Unique
    private static boolean stellar_core$concurrent = false;
    @Final
    @Shadow
    private static Map<ResourceLocation, IModel> cache;
    @Final
    @Shadow
    private static Set<ICustomModelLoader> loaders;
    @Shadow
    private static IResourceManager manager;

    @Shadow
    public static ResourceLocation getActualLocation(ResourceLocation location) {
        return null;
    }

    @Shadow
    public static IModel getMissingModel() {
        return null;
    }

    @Shadow
    public static IModel getModelOrMissing(ResourceLocation location) {
        return null;
    }

    @Shadow
    public static IModel getModel(ResourceLocation location) {
        return null;
    }

    @Inject(method={"registerLoader"}, at={@At(value="RETURN")}, remap=false)
    private static void injectRegisterLoader(ICustomModelLoader loader, CallbackInfo ci) {
        Class<?> loaderClass = loader.getClass();
        StellarLog.LOG.info("[StellarCore-ParallelModelLoader] Registered model loader: {}, AsyncBlackListed: {}", (Object)loaderClass.getName(), (Object)ParallelModelLoaderAsyncBlackList.INSTANCE.isInSet(loaderClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Inject(method={"getModel"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void getModel(ResourceLocation location, CallbackInfoReturnable<IModel> cir) throws Exception {
        IModel model;
        Object object;
        IModel cached = stellar_core$cache.get(location);
        if (cached != null) {
            cir.setReturnValue((Object)cached);
            return;
        }
        for (ResourceLocation loading : stellar_core$LOADING_MODELS.get()) {
            if (location.getClass() != loading.getClass() || !location.equals((Object)loading)) continue;
            throw new ModelLoaderRegistry.LoaderException("circular model dependencies, stack: [" + Joiner.on((String)", ").join((Iterable)stellar_core$LOADING_MODELS.get()) + "]");
        }
        stellar_core$LOADING_MODELS.get().addLast(location);
        try {
            object = stellar_core$aliases;
            // MONITORENTER : object
            ResourceLocation aliased = stellar_core$aliases.get(location);
            if (aliased != null) {
                cir.setReturnValue((Object)MixinModelLoaderRegistry.getModel(aliased));
                // MONITOREXIT : object
                return;
            }
            // MONITOREXIT : object
            if (!stellar_core$concurrent) {
                StellarLog.LOG.warn("[StellarCore-ParallelModelLoader] A mod trying to load model `{}` without concurrent state, it may cause some performance issues.", (Object)location);
            }
            ResourceLocation actual = MixinModelLoaderRegistry.getActualLocation(location);
            Object accepted = null;
            for (ICustomModelLoader loader : loaders) {
                try {
                    if (!loader.accepts(actual)) continue;
                    if (accepted != null) {
                        throw new ModelLoaderRegistry.LoaderException(String.format("2 loaders (%s and %s) want to load the same model %s", accepted, loader, location));
                    }
                    accepted = loader;
                }
                catch (Exception e) {
                    throw new ModelLoaderRegistry.LoaderException(String.format("Exception checking if model %s can be loaded with loader %s, skipping", location, loader), (Throwable)e);
                }
            }
            if (accepted == null) {
                ICustomModelLoader iCustomModelLoader = MixinModelLoaderRegistry.stellar_core$getVariantLoader();
                if (iCustomModelLoader.accepts(actual)) {
                    accepted = iCustomModelLoader;
                } else {
                    ICustomModelLoader vanillaLoader = MixinModelLoaderRegistry.stellar_core$getVanillaLoader();
                    if (vanillaLoader.accepts(actual)) {
                        accepted = vanillaLoader;
                    }
                }
            }
            if (accepted == null) {
                throw new ModelLoaderRegistry.LoaderException("no suitable loader found for the model " + location + ", skipping");
            }
            try {
                if (ParallelModelLoaderAsyncBlackList.INSTANCE.isInSet(accepted.getClass())) {
                    Object object2 = accepted;
                    // MONITORENTER : object2
                    model = accepted.loadModel(actual);
                    // MONITOREXIT : object2
                } else {
                    model = accepted.loadModel(actual);
                }
            }
            catch (Exception exception) {
                throw new ModelLoaderRegistry.LoaderException(String.format("Exception loading model %s with loader %s, skipping", location, accepted), (Throwable)exception);
            }
            if (model == MixinModelLoaderRegistry.getMissingModel()) {
                throw new ModelLoaderRegistry.LoaderException(String.format("Loader %s returned missing model while loading model %s", accepted, location));
            }
            if (model == null) {
                throw new ModelLoaderRegistry.LoaderException(String.format("Loader %s returned null while loading model %s", accepted, location));
            }
            if (!stellar_core$concurrent) {
                Set<ResourceLocation> set = stellar_core$textures;
                // MONITORENTER : set
                stellar_core$textures.addAll(model.getTextures());
                // MONITOREXIT : set
            } else {
                stellar_core$textures.addAll(model.getTextures());
            }
        }
        finally {
            ResourceLocation resourceLocation = stellar_core$LOADING_MODELS.get().removeLast();
            if (resourceLocation != location) {
                throw new IllegalStateException("Corrupted loading model stack: " + resourceLocation + " != " + location);
            }
        }
        if (!stellar_core$concurrent) {
            object = stellar_core$cache;
            // MONITORENTER : object
            stellar_core$cache.put(location, model);
            // MONITOREXIT : object
        } else {
            stellar_core$cache.put(location, model);
        }
        object = model.getDependencies().iterator();
        while (true) {
            if (!object.hasNext()) {
                cir.setReturnValue((Object)model);
                return;
            }
            ResourceLocation dep = (ResourceLocation)object.next();
            MixinModelLoaderRegistry.getModelOrMissing(dep);
        }
    }

    @Overwrite
    public static boolean loaded(ResourceLocation location) {
        return stellar_core$cache.containsKey(location);
    }

    @Overwrite
    public static void clearModelCache(IResourceManager newManager) {
        manager = newManager;
        ModelLoaderRegistryRef.instance = (ConcurrentModelLoaderRegistry)new ModelLoaderRegistry();
        stellar_core$aliases.clear();
        stellar_core$textures.clear();
        stellar_core$cache.clear();
        stellar_core$cache.put(new ResourceLocation("minecraft:builtin/generated"), (IModel)ItemLayerModel.INSTANCE);
        stellar_core$cache.put(new ResourceLocation("minecraft:block/builtin/generated"), (IModel)ItemLayerModel.INSTANCE);
        stellar_core$cache.put(new ResourceLocation("minecraft:item/builtin/generated"), (IModel)ItemLayerModel.INSTANCE);
    }

    @Overwrite
    static Iterable<ResourceLocation> getTextures() {
        return stellar_core$textures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"addAlias"}, at=@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"))
    private static Object redirectAddAlias(Map<ResourceLocation, ResourceLocation> instance, Object k, Object v) {
        if (stellar_core$concurrent) {
            return stellar_core$aliases.put((ResourceLocation)k, (ResourceLocation)v);
        }
        Map<ResourceLocation, ResourceLocation> map = stellar_core$aliases;
        synchronized (map) {
            return stellar_core$aliases.put((ResourceLocation)k, (ResourceLocation)v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"getMissingModel(Lnet/minecraft/util/ResourceLocation;Ljava/lang/Throwable;)Lnet/minecraftforge/client/model/IModel;"}, at=@At(value="INVOKE", target="Ljava/util/Set;addAll(Ljava/util/Collection;)Z"))
    private static boolean redirectGetMissingModel(Set<ResourceLocation> instance, Collection<ResourceLocation> es) {
        if (stellar_core$concurrent) {
            return stellar_core$textures.addAll(es);
        }
        Map<ResourceLocation, ResourceLocation> map = stellar_core$aliases;
        synchronized (map) {
            return stellar_core$textures.addAll(es);
        }
    }

    @Override
    public void stellar_core$toConcurrent() {
        if (stellar_core$concurrent) {
            return;
        }
        stellar_core$cache = new ConcurrentHashMap<ResourceLocation, IModel>(stellar_core$cache);
        stellar_core$aliases = new ConcurrentHashMap<ResourceLocation, ResourceLocation>(stellar_core$aliases);
        stellar_core$textures = Collections.newSetFromMap(new ConcurrentHashMap());
        stellar_core$concurrent = true;
    }

    @Override
    public void stellar_core$writeToOriginalMap() {
        cache.putAll(stellar_core$cache);
    }

    @Override
    public void stellar_core$toDefault() {
        if (!stellar_core$concurrent) {
            return;
        }
        if (StellarCoreConfig.PERFORMANCE.vanilla.wipeModelCache) {
            long startTime = System.currentTimeMillis();
            int removed = MixinModelLoaderRegistry.stellar_core$wipeCache();
            StellarLog.LOG.info("[StellarCore-ParallelModelLoader] Removed {} (Before: {}) model cache, took {}ms.", (Object)removed, (Object)cache.size(), (Object)(System.currentTimeMillis() - startTime));
            stellar_core$cache = new Object2ObjectOpenHashMap(stellar_core$cache);
        } else {
            stellar_core$cache = new Object2ObjectOpenHashMap(cache);
        }
        cache.clear();
        stellar_core$aliases = new Object2ObjectOpenHashMap(stellar_core$aliases);
        stellar_core$textures = new ObjectOpenHashSet();
        stellar_core$concurrent = false;
    }

    @Unique
    private static int stellar_core$wipeCache() {
        AtomicInteger removeCount = new AtomicInteger();
        ReferenceOpenHashSet tmpSet = new ReferenceOpenHashSet(stellar_core$cache.keySet());
        (tmpSet.size() > 15000 ? tmpSet.parallelStream() : tmpSet.stream()).filter(MixinModelLoaderRegistry::stellar_core$shouldRemove).forEach(key -> {
            stellar_core$cache.remove(key);
            removeCount.incrementAndGet();
        });
        return removeCount.get();
    }

    @Unique
    private static boolean stellar_core$shouldRemove(ResourceLocation key) {
        String namespace = key.func_110624_b();
        if ("minecraft".equals(namespace) || "fml".equals(namespace) || "forge".equals(namespace)) {
            return false;
        }
        String path = key.func_110623_a();
        return !path.endsWith("/generated") && !path.startsWith("builtin/");
    }

    @Unique
    private static ICustomModelLoader stellar_core$getVariantLoader() {
        try {
            return (ICustomModelLoader)Class.forName("net.minecraftforge.client.model.ModelLoader$VariantLoader").getEnumConstants()[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Unique
    private static ICustomModelLoader stellar_core$getVanillaLoader() {
        try {
            return (ICustomModelLoader)Class.forName("net.minecraftforge.client.model.ModelLoader$VanillaLoader").getEnumConstants()[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

