/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.minecraft.forge.parallelmodelloader;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.llamalad7.mixinextras.sugar.Local;
import github.kasuminova.stellarcore.client.integration.railcraft.RCModelBaker;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.StellarLog;
import github.kasuminova.stellarcore.mixin.minecraft.forge.parallelmodelloader.AccessorBlockStateMapper;
import github.kasuminova.stellarcore.mixin.util.DefaultTextureGetter;
import github.kasuminova.stellarcore.shaded.org.jctools.maps.NonBlockingHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelBlockDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.BlockStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ProgressManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelLoader.class})
public abstract class MixinModelLoader
extends ModelBakery {
    @Final
    @Mutable
    @Shadow(remap=false)
    private Map<ModelResourceLocation, IModel> stateModels;
    @Final
    @Mutable
    @Shadow(remap=false)
    private Map<ModelResourceLocation, ModelBlockDefinition> multipartDefinitions;
    @Final
    @Mutable
    @Shadow(remap=false)
    private Map<ModelBlockDefinition, IModel> multipartModels;
    @Final
    @Mutable
    @Shadow(remap=false)
    private Map<ModelBlockDefinition, IModel> loadingExceptions;
    @Unique
    private boolean stellar_core$concurrent = true;
    @Unique
    private static Class<?> stellar_core$ItemLoadingException = null;
    @Unique
    private static Constructor<?> stellar_core$ItemLoadingExceptionConstructor = null;
    @Unique
    private static Class<?> stellar_core$ModelLoaderRegistry = null;
    @Unique
    private static MethodHandle stellar_core$addAlias = null;
    @Unique
    private static MethodHandle stellar_core$getMissingModel = null;

    public MixinModelLoader() {
        super(null, null, null);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=false)
    private void injectInit(IResourceManager resourceManagerIn, TextureMap textureMapIn, BlockModelShapes blockModelShapesIn, CallbackInfo ci) {
        this.stateModels = new ConcurrentHashMap<ModelResourceLocation, IModel>();
        this.multipartDefinitions = new ConcurrentHashMap<ModelResourceLocation, ModelBlockDefinition>();
        this.multipartModels = new ConcurrentHashMap<ModelBlockDefinition, IModel>();
        this.loadingExceptions = new ConcurrentHashMap<ModelBlockDefinition, IModel>();
    }

    @Shadow(remap=false)
    protected abstract IModel getMissingModel();

    @Redirect(method={"setupModelRegistry"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/HashMultimap;keySet()Ljava/util/Set;", ordinal=1, remap=false))
    private Set stellar_core$injectSetupModelRegistry(HashMultimap<IModel, ModelResourceLocation> instance, @Local(name={"bakedModels"}) Map<IModel, IBakedModel> bakedModels, @Local(name={"models"}) HashMultimap<IModel, ModelResourceLocation> models, @Local(name={"bakeBar"}) ProgressManager.ProgressBar bakeBar, @Local(name={"missingBaked"}) IBakedModel missingBaked) {
        long startTime = System.currentTimeMillis();
        NonBlockingHashMap bakedModelsConcurrent = new NonBlockingHashMap();
        DefaultTextureGetter textureGetter = new DefaultTextureGetter();
        ((Stream)models.keySet().stream().parallel()).forEach(model -> {
            Set locations = models.get(model);
            String modelLocations = "[" + Joiner.on((String)", ").join((Iterable)locations) + "]";
            ProgressManager.ProgressBar progressBar = bakeBar;
            synchronized (progressBar) {
                bakeBar.step(modelLocations);
            }
            if (model == this.getMissingModel()) {
                bakedModelsConcurrent.put(model, missingBaked);
                return;
            }
            try {
                IBakedModel loaded = RCModelBaker.load(locations, model, (Function<ResourceLocation, TextureAtlasSprite>)((Object)textureGetter));
                if (loaded != null) {
                    bakedModelsConcurrent.put(model, loaded);
                    return;
                }
                bakedModelsConcurrent.put(model, model.bake(model.getDefaultState(), DefaultVertexFormats.field_176599_b, (Function)((Object)textureGetter)));
            }
            catch (Exception e) {
                if (!StellarCoreConfig.FEATURES.vanilla.shutUpModelLoader) {
                    FMLLog.log.error("Exception baking model for location(s) {}:", (Object)modelLocations, (Object)e);
                }
                bakedModelsConcurrent.put(model, missingBaked);
            }
        });
        StellarLog.LOG.info("[StellarCore-ParallelModelLoader] Baked {} models, took {}ms.", (Object)bakedModelsConcurrent.size(), (Object)(System.currentTimeMillis() - startTime));
        bakedModels.putAll(bakedModelsConcurrent);
        return Collections.emptySet();
    }

    @Redirect(method={"loadBlocks"}, at=@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;"))
    private Iterator<Object> stellar_core$injectLoadBlocks(List<Block> blocks, @Local(name={"blockBar"}) ProgressManager.ProgressBar blockBar, @Local(name={"mapper"}) BlockStateMapper mapper) {
        long startTime = System.currentTimeMillis();
        this.stellar_core$toConcurrent();
        blocks.parallelStream().forEach(block -> {
            ProgressManager.ProgressBar progressBar = blockBar;
            synchronized (progressBar) {
                blockBar.step(block.getRegistryName().toString());
            }
            Map<IBlockState, ModelResourceLocation> map = ((AccessorBlockStateMapper)mapper).getBlockStateMap();
            ModelResourceLocation modelRL = map.get(block);
            if (modelRL != null) {
                ModelResourceLocation modelResourceLocation = modelRL;
                synchronized (modelResourceLocation) {
                    Set locations = mapper.func_188182_a(block);
                    locations.parallelStream().forEach(location -> this.loadBlock(mapper, (Block)block, (ResourceLocation)location));
                }
            } else {
                Set locations = mapper.func_188182_a(block);
                locations.parallelStream().forEach(location -> this.loadBlock(mapper, (Block)block, (ResourceLocation)location));
            }
        });
        this.stellar_core$toDefault();
        StellarLog.LOG.info("[StellarCore-ParallelModelLoader] Loaded {} block models, took {}ms.", (Object)blocks.size(), (Object)(System.currentTimeMillis() - startTime));
        return Collections.emptyIterator();
    }

    @Unique
    private void stellar_core$toConcurrent() {
        if (!this.stellar_core$concurrent) {
            this.stateModels = new ConcurrentHashMap<ModelResourceLocation, IModel>(this.stateModels);
            this.multipartDefinitions = new ConcurrentHashMap<ModelResourceLocation, ModelBlockDefinition>(this.multipartDefinitions);
            this.multipartModels = new ConcurrentHashMap<ModelBlockDefinition, IModel>(this.multipartModels);
            this.loadingExceptions = new ConcurrentHashMap<ModelBlockDefinition, IModel>(this.loadingExceptions);
            this.stellar_core$concurrent = true;
        }
    }

    @Unique
    private void stellar_core$toDefault() {
        this.stateModels = new Object2ObjectOpenHashMap(this.stateModels);
        this.multipartDefinitions = new Object2ObjectOpenHashMap(this.multipartDefinitions);
        this.multipartModels = new Object2ObjectOpenHashMap(this.multipartModels);
        this.loadingExceptions = new Object2ObjectOpenHashMap(this.loadingExceptions);
        this.stellar_core$concurrent = false;
    }

    @Unique
    private static Exception stellar_core$createItemLoadingException(String message, Exception normalException, Exception blockstateException) {
        try {
            return (Exception)stellar_core$ItemLoadingExceptionConstructor.newInstance(message, normalException, blockstateException);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Unique
    private static void stellar_core$addAlias(ResourceLocation from, ResourceLocation to) {
        try {
            stellar_core$addAlias.invoke(from, to);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Unique
    private static IModel stellar_core$getMissingModel(ResourceLocation location, Throwable cause) {
        try {
            return stellar_core$getMissingModel.invoke(location, cause);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Unique
    private static void stellar_core$initializeReflect() {
        try {
            stellar_core$ItemLoadingException = Class.forName("net.minecraftforge.client.model.ModelLoader$ItemLoadingException");
            stellar_core$ItemLoadingExceptionConstructor = stellar_core$ItemLoadingException.getConstructor(String.class, Exception.class, Exception.class);
            stellar_core$ModelLoaderRegistry = Class.forName("net.minecraftforge.client.model.ModelLoaderRegistry");
            Method addAlias = stellar_core$ModelLoaderRegistry.getDeclaredMethod("addAlias", ResourceLocation.class, ResourceLocation.class);
            addAlias.setAccessible(true);
            stellar_core$addAlias = MethodHandles.lookup().unreflect(addAlias);
            stellar_core$ModelLoaderRegistry = Class.forName("net.minecraftforge.client.model.ModelLoaderRegistry");
            Method getMissingModel = stellar_core$ModelLoaderRegistry.getDeclaredMethod("getMissingModel", ResourceLocation.class, Throwable.class);
            getMissingModel.setAccessible(true);
            stellar_core$getMissingModel = MethodHandles.lookup().unreflect(getMissingModel);
        }
        catch (Throwable e) {
            throw new RuntimeException("[StellarCore-ParallelModelLoader] Caught a fatal exception, please report to mod author!", e);
        }
    }
}

