/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.mekanism;

import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.EnumSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.energy.EnergyStack;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.common.base.EnergyAcceptorWrapper;
import mekanism.common.base.target.EnergyAcceptorTarget;
import mekanism.common.transmitters.grid.EnergyNetwork;
import mekanism.common.util.EmitUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnergyNetwork.class})
public abstract class MixinEnergyNetwork
extends DynamicNetwork<EnergyAcceptorWrapper, EnergyNetwork, EnergyStack> {
    @Unique
    private final Set<EnergyAcceptorTarget> stellar_core$targets = new ObjectOpenHashSet();

    @Inject(method={"tickEmit"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void injectTickEmit(double energyToSend, CallbackInfoReturnable<Double> cir) {
        if (!StellarCoreConfig.PERFORMANCE.mekanism.energyNetwork) {
            return;
        }
        this.stellar_core$targets.clear();
        int totalHandlers = 0;
        for (Coord4D coord : this.possibleAcceptors) {
            TileEntity tile;
            EnumSet sides = (EnumSet)this.acceptorDirections.get(coord);
            if (sides == null || sides.isEmpty() || (tile = coord.getTileEntity((IBlockAccess)this.getWorld())) == null) continue;
            EnergyAcceptorTarget target = new EnergyAcceptorTarget();
            for (EnumFacing side : sides) {
                EnergyAcceptorWrapper acceptor = EnergyAcceptorWrapper.get((TileEntity)tile, (EnumFacing)side);
                if (acceptor == null || !acceptor.canReceiveEnergy(side) || !acceptor.needsEnergy(side)) continue;
                target.addHandler(side, (Object)acceptor);
            }
            int curHandlers = target.getHandlers().size();
            if (curHandlers <= 0) continue;
            this.stellar_core$targets.add(target);
            totalHandlers += curHandlers;
        }
        cir.setReturnValue((Object)EmitUtils.sendToAcceptors(this.stellar_core$targets, (int)totalHandlers, (double)energyToSend));
    }
}

