/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.igi;

import com.github.lunatrius.ingameinfo.InGameInfoCore;
import com.github.lunatrius.ingameinfo.client.gui.overlay.Info;
import com.github.lunatrius.ingameinfo.handler.ConfigurationHandler;
import github.kasuminova.stellarcore.client.util.RenderUtils;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.mixin.util.IMixinInGameInfoCore;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={InGameInfoCore.class})
public class MixinInGameInfoCore
implements IMixinInGameInfoCore {
    @Unique
    private final List<Runnable> stellar_core$postDrawList = new LinkedList<Runnable>();
    @Shadow(remap=false)
    @Final
    private List<Info> info;
    @Unique
    private Framebuffer stellar_core$fbo = null;
    @Unique
    private boolean stellar_core$refreshFBO = true;
    @Unique
    private boolean stellar_core$postDrawing = true;
    @Unique
    private int stellar_core$displayWidth = 0;
    @Unique
    private int stellar_core$displayHeight = 0;
    @Unique
    private long stellar_core$lastRenderMS = 0L;

    @Inject(method={"onTickRender"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void onTickRender(CallbackInfo ci) {
        if (!StellarCoreConfig.PERFORMANCE.inGameInfoXML.hudFrameBuffer) {
            return;
        }
        if (!OpenGlHelper.field_148823_f) {
            return;
        }
        ci.cancel();
        int timeRange = 1000 / StellarCoreConfig.PERFORMANCE.inGameInfoXML.hudFrameRate;
        if (System.currentTimeMillis() - this.stellar_core$lastRenderMS > (long)timeRange) {
            this.stellar_core$refreshFBO = true;
            this.stellar_core$lastRenderMS = System.currentTimeMillis();
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        this.stellar_core$postDrawing = false;
        if (this.stellar_core$fbo == null) {
            this.stellar_core$displayWidth = minecraft.field_71443_c;
            this.stellar_core$displayHeight = minecraft.field_71440_d;
            this.stellar_core$fbo = new Framebuffer(this.stellar_core$displayWidth, this.stellar_core$displayHeight, false);
            this.stellar_core$fbo.field_147625_i[0] = 0.0f;
            this.stellar_core$fbo.field_147625_i[1] = 0.0f;
            this.stellar_core$fbo.field_147625_i[2] = 0.0f;
        }
        if (this.stellar_core$refreshFBO) {
            this.stellar_core$postDrawList.clear();
            GlStateManager.func_179094_E();
            this.stellar_core$renderToFBO(minecraft);
            GlStateManager.func_179121_F();
            this.stellar_core$refreshFBO = false;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtils.renderFramebuffer(minecraft, this.stellar_core$fbo);
        this.stellar_core$postDrawing = true;
        this.stellar_core$postDrawList.forEach(Runnable::run);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Unique
    private void stellar_core$renderToFBO(Minecraft minecraft) {
        if (this.stellar_core$displayWidth != minecraft.field_71443_c || this.stellar_core$displayHeight != minecraft.field_71440_d) {
            this.stellar_core$displayWidth = minecraft.field_71443_c;
            this.stellar_core$displayHeight = minecraft.field_71440_d;
            this.stellar_core$fbo.func_147613_a(this.stellar_core$displayWidth, this.stellar_core$displayHeight);
        } else {
            this.stellar_core$fbo.func_147614_f();
        }
        this.stellar_core$fbo.func_147610_a(false);
        GlStateManager.func_179084_k();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)ConfigurationHandler.scale, (float)ConfigurationHandler.scale, (float)ConfigurationHandler.scale);
        this.info.forEach(Info::draw);
        GlStateManager.func_179121_F();
        Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
    }

    @Override
    public void addPostDrawAction(Runnable action) {
        this.stellar_core$postDrawList.add(action);
    }

    @Override
    public boolean isPostDrawing() {
        return this.stellar_core$postDrawing;
    }
}

