/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.enderioconduits;

import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.conduits.conduit.AbstractConduit;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import javax.annotation.Nonnull;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractConduit.class})
public abstract class MixinAbstractConduit {
    @Shadow(remap=false)
    protected boolean readFromNbt;
    @Shadow(remap=false)
    private boolean clientStateDirty;

    @Shadow(remap=false)
    protected abstract void updateNetwork(World var1);

    @Shadow(remap=false)
    protected abstract void updateConnections();

    @Shadow(remap=false)
    @Nonnull
    public abstract IConduitBundle getBundle();

    @Inject(method={"updateEntity"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void updateEntity(World world, CallbackInfo ci) {
        if (!StellarCoreConfig.PERFORMANCE.enderIOConduits.abstractConduit) {
            return;
        }
        ci.cancel();
        if (world.field_72995_K) {
            return;
        }
        this.updateNetwork(world);
        this.updateConnections();
        this.readFromNbt = false;
        if (this.clientStateDirty) {
            this.getBundle().dirty();
            this.clientStateDirty = false;
        }
    }
}

