/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.stellarcore.mixin.enderio;

import crazypants.enderio.base.recipe.IRecipeInput;
import crazypants.enderio.base.recipe.MachineRecipeInput;
import crazypants.enderio.base.recipe.Recipe;
import github.kasuminova.stellarcore.common.config.StellarCoreConfig;
import github.kasuminova.stellarcore.common.util.HashedItemStack;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Recipe.class}, remap=false)
public class MixinRecipe {
    @Shadow
    @Final
    @Nonnull
    private IRecipeInput[] inputs;
    @Unique
    private final Map<HashedItemStack, Boolean> stellar_core$anyInputItemCache = new WeakHashMap<HashedItemStack, Boolean>();
    @Unique
    private final Map<Fluid, Boolean> stellar_core$anyInputFluidCache = new WeakHashMap<Fluid, Boolean>();

    @Inject(method={"isAnyInput"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectIsAnyInput(MachineRecipeInput realInput, CallbackInfoReturnable<Boolean> cir) {
        Boolean ret;
        if (!StellarCoreConfig.PERFORMANCE.enderIO.recipe) {
            return;
        }
        ItemStack item = realInput.item;
        FluidStack fluid = realInput.fluid;
        HashedItemStack hashedStack = null;
        if (!item.func_190926_b() && (ret = this.stellar_core$anyInputItemCache.get(hashedStack = HashedItemStack.ofTagUnsafe(item))) != null) {
            cir.setReturnValue((Object)ret);
            return;
        }
        if (fluid != null && (ret = this.stellar_core$anyInputFluidCache.get(fluid.getFluid())) != null) {
            cir.setReturnValue((Object)ret);
            return;
        }
        for (IRecipeInput recipeInput : this.inputs) {
            if (recipeInput == null || !recipeInput.isInput(item) && !recipeInput.isInput(realInput.fluid)) continue;
            this.stellar_core$storeCache(hashedStack, fluid, true);
            cir.setReturnValue((Object)true);
            return;
        }
        this.stellar_core$storeCache(hashedStack, fluid, false);
        cir.setReturnValue((Object)false);
    }

    @Unique
    private void stellar_core$storeCache(HashedItemStack hashedItemStack, FluidStack fluid, boolean value) {
        if (hashedItemStack != null) {
            this.stellar_core$anyInputItemCache.put(hashedItemStack, value);
        }
        if (fluid != null) {
            this.stellar_core$anyInputFluidCache.put(fluid.getFluid(), value);
        }
    }
}

